package tocraft.walkers.mixin.accessor;

import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3414;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_1309.class)
public interface LivingEntityAccessor {
    @Accessor
    boolean isJumping();

    @Invoker
    void callUpdatingUsingItem();

    @Invoker
    class_3414 callGetHurtSound(class_1282 source);

    @Invoker
    class_3414 callGetDeathSound();

    @Invoker
    void callPlayBlockFallSound();

    @Invoker
    int callCalculateFallDamage(float fallDistance, float damageMultiplier);

    @Invoker
    float callGetSoundVolume();

    @Invoker
    float callGetVoicePitch();

    @Invoker
    void callSetLivingEntityFlag(int mask, boolean value);

    @Accessor
    float getSwimAmount();

    @Accessor
    void setSwimAmount(float swimAmount);

    @Accessor
    float getSwimAmountO();

    @Accessor
    void setSwimAmountO(float swimAmount);
}
