package tocraft.walkers.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1453;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4174;
import net.minecraft.class_6880;
import net.minecraft.world.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.impl.ShapeDataProvider;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.*;

import java.util.List;

@SuppressWarnings({"resource", "unused"})
@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements NearbySongAccessor {
    @Shadow
    public abstract void method_5768();

    @Shadow
    public abstract boolean method_5643(class_1282 source, float amount);

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    //#if MC>=1205
    @WrapOperation(method = "travel", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal = 0))
    private boolean slowFall(class_1309 instance, class_6880<class_1291> effect, Operation<Boolean> original) {
    //#else
    //$$ @WrapOperation(method = "travel", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal = 0))
    //$$ private boolean slowFall(LivingEntity instance, MobEffect effect, Operation<Boolean> original) {
        //#endif
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                boolean bool = false;
                for (FlyingTrait<?> flyingTrait : TraitRegistry.get(shape, FlyingTrait.ID).stream().map(trait -> (FlyingTrait<?>) trait).toList()) {
                    if (flyingTrait.slowFalling) {
                        bool = true;
                        break;
                    }
                }
                if (!this.method_5715() && (bool || TraitRegistry.has(shape, SlowFallingTrait.ID))) {
                    return true;
                }
            }
        }

        return original.call(instance, effect);
    }

    //#if MC>=1205
    @ModifyVariable(method = "travel", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal = 1), ordinal = 0)
    //#else
    //$$ @ModifyVariable(method = "travel", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal = 1), ordinal = 0)
    //#endif
    public float applyWaterCreatureSwimSpeedBoost(float j) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            // Apply 'Dolphin's Grace' status effect benefits if the player's shape is a
            // water creature
            for (ShapeTrait<class_1309> trait : TraitRegistry.get(shape, AquaticTrait.ID)) {
                if (((AquaticTrait<class_1309>) trait).isAquatic) {
                    return .96f;
                }
            }
        }

        return j;
    }

    @Inject(method = "causeFallDamage", at = @At(value = "HEAD"), cancellable = true)
    private void causeFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource,
                                 CallbackInfoReturnable<Boolean> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                boolean takesFallDamage = shape.method_5747(fallDistance, damageMultiplier, damageSource);
                int damageAmount = ((LivingEntityAccessor) shape).callCalculateFallDamage(fallDistance,
                        damageMultiplier);

                if (takesFallDamage && damageAmount > 0) {
                    class_1309.class_6823 fallSounds = shape.method_39760();
                    this.method_5783(damageAmount > 4 ? fallSounds.comp_302() : fallSounds.comp_301(), 1.0F, 1.0F);
                    ((LivingEntityAccessor) shape).callPlayBlockFallSound();
                    //#if MC>1182
                    this.method_5643(method_48923().method_48827(), (float) damageAmount);
                    //#else
                    //$$ this.hurt(DamageSource.FALL, (float) damageAmount);
                    //#endif
                    cir.setReturnValue(true);
                } else {
                    cir.setReturnValue(false);
                }
            }
        }
    }

    @Inject(method = "hasEffect", at = @At("HEAD"), cancellable = true)
    //#if MC>=1205
    private void returnHasNightVision(class_6880<class_1291> effect, CallbackInfoReturnable<Boolean> cir) {
    //#else
    //$$ private void returnHasNightVision(MobEffect effect, CallbackInfoReturnable<Boolean> cir) {
        //#endif
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait<class_1309>> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait<class_1309>) trait).toList();
                for (MobEffectTrait<class_1309> mobEffectTrait : traitList) {
                    if (!mobEffectTrait.showInInventory && mobEffectTrait.applyToSelf && effect.equals(mobEffectTrait.mobEffectInstance.method_5579())) {
                        cir.setReturnValue(true);
                        return;
                    }
                }
            }

            for (ShapeTrait<class_1309> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                //#if MC>=1205
                if (((ImmunityTrait<class_1309>) immunityTrait).effect.equals(effect.comp_349())) {
                //#else
                //$$ if (((ImmunityTrait<LivingEntity>) immunityTrait).effect.equals(effect)) {
                //#endif
                    cir.setReturnValue(false);
                    return;
                }
            }
        }
    }

    @Inject(method = "getEffect", at = @At("HEAD"), cancellable = true)
    //#if MC>=1205
    private void returnNightVisionInstance(class_6880<class_1291> effect, CallbackInfoReturnable<class_1293> cir) {
    //#else
    //$$ private void returnNightVisionInstance(MobEffect effect, CallbackInfoReturnable<MobEffectInstance> cir) {
        //#endif
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait<class_1309>> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait<class_1309>) trait).toList();
                for (MobEffectTrait<class_1309> mobEffectTrait : traitList) {
                    if (!mobEffectTrait.showInInventory && mobEffectTrait.applyToSelf) {
                        class_1293 mobEffectInstance = mobEffectTrait.mobEffectInstance;
                        if (effect.equals(mobEffectInstance.method_5579())) {
                            cir.setReturnValue(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()));
                            return;
                        }
                    }
                }
            }

            for (ShapeTrait<class_1309> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                //#if MC>=1205
                if (((ImmunityTrait<class_1309>) immunityTrait).effect.equals(effect.comp_349())) {
                    //#else
                    //$$ if (((ImmunityTrait<LivingEntity>) immunityTrait).effect.equals(effect)) {
                    //#endif
                    cir.setReturnValue(null);
                    return;
                }
            }
        }
    }

    //#if MC<1205
    //$$ @Inject(at = @At("HEAD"), method = "getEyeHeight", cancellable = true)
    //$$ public void getEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
    //$$     if ((LivingEntity) (Object) this instanceof Player player) {
    //$$
    //$$         // this is cursed
    //$$         try {
    //$$             LivingEntity shape = PlayerShape.getCurrentShape(player);
    //$$
    //$$             if (shape != null) {
    //$$                 float shapeEyeHeight = shape.getEyeHeight(pose);
    //$$                 if (pose == Pose.CROUCHING && TraitRegistry.has(shape, HumanoidTrait.ID)) {
    //$$                     cir.setReturnValue(shapeEyeHeight * 1.27F / 1.62F);
    //$$                     return;
    //$$                 }
    //$$
    //$$                 cir.setReturnValue(shapeEyeHeight);
    //$$             }
    //$$         } catch (Exception ignored) {
    //$$         }
    //$$     }
    //$$ }
    //#endif

    @Inject(method = "isSensitiveToWater", at = @At("HEAD"), cancellable = true)
    protected void shape_isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 entity = PlayerShape.getCurrentShape(player);

            if (entity != null) {
                cir.setReturnValue(entity.method_29503());
            }
        }
    }

    @Unique
    private boolean walkers$nearbySongPlaying = false;

    @Environment(EnvType.CLIENT)
    @Inject(method = "setRecordPlayingNearby", at = @At("RETURN"))
    protected void shape_setRecordPlayingNearby(class_2338 songPosition, boolean playing, CallbackInfo ci) {
        if ((class_1309) (Object) this instanceof class_1657) {
            walkers$nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean shape_isNearbySongPlaying() {
        return walkers$nearbySongPlaying;
    }

    @Inject(method = "isInvertedHealAndHarm", at = @At("HEAD"), cancellable = true)
    protected void shape_isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_5999());
            }
        }
    }

    @Inject(method = "canStandOnFluid", at = @At("HEAD"), cancellable = true)
    protected void shape_canStandOnFluid(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                if (shape.method_26319(state)) {
                    cir.setReturnValue(true);
                } else {
                    for (StandOnFluidTrait<?> standOnFluidTrait : TraitRegistry.get(shape, StandOnFluidTrait.ID).stream().map(entry -> (StandOnFluidTrait<?>) entry).toList()) {
                        if (state.method_15767(standOnFluidTrait.fluidTagKey)) {
                            cir.setReturnValue(true);
                            return;
                        }
                    }
                }
            }
        }
    }

    @Inject(method = "onClimbable", at = @At("HEAD"), cancellable = true)
    protected void shape_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                class_2680 blockState = CEntity.level(this).method_8320(this.method_24515());
                for (ClimbBlocksTrait<?> climbBlocksTrait : TraitRegistry.get(shape, ClimbBlocksTrait.ID).stream().map(entry -> (ClimbBlocksTrait<?>) entry).toList()) {
                    for (class_2248 invalidBlock : climbBlocksTrait.invalidBlocks) {
                        if (blockState.method_27852(invalidBlock)) {
                            return;
                        }
                    }

                    if (climbBlocksTrait.validBlocks.isEmpty()) {
                        cir.setReturnValue(this.field_5976);
                    } else {
                        for (class_2248 validBlock : climbBlocksTrait.validBlocks) {
                            if (blockState.method_27852(validBlock)) {
                                cir.setReturnValue(!climbBlocksTrait.horizontalCollision || this.field_5976);
                                return;
                            }
                        }
                    }
                }
            }
        }
    }


    //#if MC>1206
    @Inject(method = "eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/food/FoodProperties;)V"))
    private void regenerateWoolFromFood(class_1937 level, class_1799 food, class_4174 foodProperties, CallbackInfoReturnable<class_1799> cir) {
    //#else
    //#if MC==1206
    //$$ @Inject(method = "eat", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/food/FoodProperties;)V"))
    //#else
    //$$ @Inject(method = "eat", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V"))
    //#endif
    //$$ private void regenerateWoolFromFood(Level level, ItemStack food, CallbackInfoReturnable<ItemStack> cir) {
        //#endif
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape instanceof class_1472 sheepShape) {
                if (sheepShape.method_6629())
                    sheepShape.method_6635(false);
            }
        }
    }

    //#if MC>1206
    @Inject(method = "eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;", at = @At(value = "RETURN"))
    private void dieFromCookies(class_1937 level, class_1799 food, class_4174 foodProperties, CallbackInfoReturnable<class_1799> cir) {
    //#else
    //$$ @Inject(method = "eat", at = @At(value = "RETURN"))
    //$$ private void dieFromCookies(Level level, ItemStack food, CallbackInfoReturnable<ItemStack> cir) {
        //#endif
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape instanceof class_1453) {
                player.method_6092(new class_1293(class_1294.field_5899, 900));
                if (player.method_7337() || !this.method_5655()) {
                    //#if MC>1182
                    this.method_5643(this.method_48923().method_48802(player), Float.MAX_VALUE);
                    //#else
                    //$$ this.hurt(DamageSource.playerAttack(player), Float.MAX_VALUE);
                    //#endif
                }
            }
        }
    }

    @Inject(method = "isSensitiveToWater", at = @At(value = "RETURN"), cancellable = true)
    private void handleWaterSensitivity(CallbackInfoReturnable<Boolean> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null) {
                cir.setReturnValue(shape.method_29503());
            }
        }
    }

    @Inject(method = "canFreeze", at = @At("RETURN"), cancellable = true)
    private void temperatureTraitPreventFreeze(CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValue()) {
            if ((Object) this instanceof class_1657) {
                class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
                if (shape != null) {
                    for (ShapeTrait<class_1309> temperatureTrait : TraitRegistry.get(shape, TemperatureTrait.ID)) {
                        if (((TemperatureTrait<class_1309>) temperatureTrait).coldEnoughToSnow) {
                            cir.setReturnValue(false);
                        }
                    }
                }
            }
        }
    }

    @Inject(method = "hurt", at = @At("HEAD"), cancellable = true)
    private void setPlayerSource(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1308 mobEntity) {
            if (((ShapeDataProvider) mobEntity).walkers$isShape()) {
                class_1282 playerDamageSource = ((ShapeDataProvider) mobEntity).walkers$playerDamageSource();
                if (playerDamageSource != null) {
                    cir.setReturnValue(this.method_5643(playerDamageSource, amount));
                }
            }
        }
    }


    @Inject(method = "hurt", at = @At("RETURN"))
    private void attackForHealthTrait(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_5529() instanceof class_1657 player) {
            boolean didHurtTarget = cir.getReturnValue();

            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (didHurtTarget && TraitRegistry.has(shape, AttackForHealthTrait.ID)) {
                player.method_6025(Math.max(1, amount / 2));
            }
        }
    }
}
