package tocraft.walkers.api.data.variants;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.*;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public record AdvancedNBTEntries(List<class_2487> variantData) {
    public static final Codec<AdvancedNBTEntries> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.unboundedMap(Codec.STRING, class_2487.field_25128).fieldOf("variants").forGetter(o -> {
                Map<String, class_2487> map = new HashMap<>();
                for (int i = 0; i < o.variantData().size(); i++) {
                    map.put(String.valueOf(i), o.variantData().get(i));
                }
                return map;
            })
    ).apply(instance, instance.stable((variantDataMap) -> {
        List<class_2487> variantData = new ArrayList<>();
        // sort map to prevent errors while creating list
        variantDataMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> Integer.parseInt(entry.getKey()))).forEach(entry -> variantData.add(entry.getValue()));
        return new AdvancedNBTEntries(variantData);
    })));

    public int getData(class_2487 tag) {
        for (class_2487 compoundTag : variantData()) {
            boolean bool = true;
            for (String key : compoundTag.method_10541()) {
                if (!tag.method_10545(key) || tag.method_10580(key) != compoundTag.method_10580(key)) {
                    bool = false;
                }
                if (!bool) {
                    break;
                }
            }
            if (bool) {
                return variantData().indexOf(compoundTag);
            }
        }

        return -1;
    }

    public void fromData(class_2487 tag, int data) {
        if (data < variantData().size()) {
            for (String key : variantData().get(data).method_10541()) {
                class_2520 value = variantData().get(data).method_10580(key);
                if (value != null) {
                    tag.method_10566(key, value);
                }
            }
        }
    }

    public int highestId() {
        return variantData().size() - 1;
    }
}
