package tocraft.walkers.api;

import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;

public class PlayerAbilities {

    /**
     * Returns an integer representing the current ability cooldown of the specified {@link class_1657} in ticks.
     *
     * <p>
     * A return value of {@code 0} represents no cooldown, while 20 is 1 second.
     *
     * @param player player to retrieve ability cooldown for
     * @return cooldown, in ticks, of the specified player's ability
     */
    public static int getCooldown(class_1657 player) {
        return ((PlayerDataProvider) player).walkers$getAbilityCooldown();
    }

    public static boolean canUseAbility(class_1657 player) {
        return !player.method_7325() && ((PlayerDataProvider) player).walkers$getAbilityCooldown() <= 0;
    }

    public static void setCooldown(class_1657 player, int cooldown) {
        ((PlayerDataProvider) player).walkers$setAbilityCooldown(cooldown);
    }

    public static void sync(class_3222 player) {
        class_2487 packet = new class_2487();
        packet.method_10569("cooldown", ((PlayerDataProvider) player).walkers$getAbilityCooldown());
        ModernNetworking.sendToPlayer(player, NetworkHandler.ABILITY_SYNC, packet);
    }
}
