package tocraft.walkers.skills.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.skills.ShapeSkill;

public class AquaticSkill<E extends class_1309> extends ShapeSkill<E> {
    public static final class_2960 ID = Walkers.id("aquatic");
    public static final Codec<AquaticSkill<?>> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.INT.optionalFieldOf("is_aquatic", 0).forGetter(o -> o.isAquatic)
    ).apply(instance, instance.stable(AquaticSkill::new)));

    public final int isAquatic;

    /**
     * @param isAquatic 0 - water mob, 1 - land and water mob, 2 - land mob
     */
    public AquaticSkill(int isAquatic) {
        this.isAquatic = isAquatic;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Codec<? extends ShapeSkill<?>> codec() {
        return CODEC;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public @Nullable class_1058 getIcon() {
        if (isAquatic == 0) {
            class_1087 itemIcon = class_310.method_1551().method_1480().method_4012().method_3304(class_1802.field_8207);
            if (itemIcon != null) {
                return itemIcon.method_4711();
            }
        } else if (isAquatic == 1) {
            return class_310.method_1551().method_18505().method_18663(class_1294.field_5923);
        }
        return super.getIcon();
    }
}
