package tocraft.walkers.mixin.player;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.impl.GrassEaterAbility;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandler;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.impl.ShapeDataProvider;
import tocraft.walkers.mixin.accessor.DolphinAccessor;
import tocraft.walkers.mixin.accessor.PufferfishAccessor;
import tocraft.walkers.mixin.accessor.SheepAccessor;
import tocraft.walkers.network.impl.VehiclePackets;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.MobEffectSkill;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1433;
import net.minecraft.class_1454;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import net.minecraft.class_5712;
import net.minecraft.class_6088;
import net.minecraft.class_7924;

@SuppressWarnings("ConstantConditions")
@Mixin(class_1657.class)
public abstract class PlayerEntityTickMixin extends class_1309 {

    private PlayerEntityTickMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @SuppressWarnings({"unchecked", "rawtypes", "ConstantConditions"})
    @Inject(method = "tick", at = @At("HEAD"))
    private void serverTick(CallbackInfo info) {
        // Tick WalkersTickHandlers on the client & server.
        @Nullable class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
        if (shape != null) {
            @Nullable WalkersTickHandler handler = WalkersTickHandlers.getHandlers().get(shape.method_5864());
            if (handler != null) {
                handler.tick((class_1657) (Object) this, shape);
            }
        }

        // Update misc. server-side entity properties for the player.
        if (!method_37908().field_9236) {
            PlayerDataProvider data = (PlayerDataProvider) this;
            data.walkers$setRemainingHostilityTime(Math.max(0, data.walkers$getRemainingHostilityTime() - 1));

            // Update cooldown & Sync
            class_3222 player = (class_3222) (Object) this;
            PlayerAbilities.setCooldown(player, Math.max(0, data.walkers$getAbilityCooldown() - 1));
            PlayerAbilities.sync(player);

            VehiclePackets.sync((class_3222) (Object) this);
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void setShapeData(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
        if (shape instanceof ShapeDataProvider shapeData) {
            if (!shapeData.walkers$isShape()) {
                shapeData.walkers$setIsShape(true);
            }
            shapeData.walkers$setPlayerDamageSource(this.method_48923().method_48802((class_1657) (Object) this));
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void pufferfishServerTick(CallbackInfo info) {
        if (!method_37908().field_9236 && this.method_5805()) {
            class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
            if (shape instanceof class_1454 pufferfishShape) {
                if (((PufferfishAccessor) pufferfishShape).getInflateCounter() > 0) {
                    if (pufferfishShape.method_6594() == 0) {
                        this.method_5783(class_3417.field_15235, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(1);
                    } else if (((PufferfishAccessor) pufferfishShape).getInflateCounter() > 40 && pufferfishShape.method_6594() == 1) {
                        this.method_5783(class_3417.field_15235, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(2);
                    }

                    ((PufferfishAccessor) pufferfishShape).setInflateCounter(((PufferfishAccessor) pufferfishShape).getInflateCounter() + 1);
                } else if (pufferfishShape.method_6594() != 0) {
                    if (((PufferfishAccessor) pufferfishShape).getDeflateTimer() > 60 && pufferfishShape.method_6594() == 2) {
                        this.method_5783(class_3417.field_15133, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(1);
                    } else if (((PufferfishAccessor) pufferfishShape).getDeflateTimer() > 100 && pufferfishShape.method_6594() == 1) {
                        this.method_5783(class_3417.field_15133, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(0);
                    }

                    ((PufferfishAccessor) pufferfishShape).setDeflateTimer(((PufferfishAccessor) pufferfishShape).getDeflateTimer() + 1);
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void dolphinServerTick(CallbackInfo info) {
        if (!method_37908().field_9236 && this.method_5805()) {
            class_1657 player = (class_1657) (Object) this;
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape instanceof class_1433) {
                class_1657 nearestPlayer = player.method_37908().method_18462(((DolphinAccessor) shape).getSWIM_WITH_PLAYER_TARGETING(), player);
                if (nearestPlayer != null && nearestPlayer.method_5681()) {
                    nearestPlayer.method_37222(new class_1293(class_1294.field_5900, 100), player);
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void applyMobEffectSkill(CallbackInfo info) {
        if (!method_37908().field_9236 && this.method_5805()) {
            class_1657 player = (class_1657) (Object) this;
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null && SkillRegistry.has(shape, MobEffectSkill.ID)) {
                List<MobEffectSkill<class_1309>> skillList = SkillRegistry.get(shape, MobEffectSkill.ID).stream().map(skill -> (MobEffectSkill<class_1309>) skill).toList();
                for (MobEffectSkill<class_1309> mobEffectSkill : skillList) {
                    class_1293 mobEffectInstance = mobEffectSkill.mobEffectInstance;
                    // apply to self
                    if (mobEffectSkill.showInInventory && mobEffectSkill.applyToSelf) {
                        player.method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), player);
                    }
                    // apply to nearby
                    switch (mobEffectSkill.applyToNearby) {
                        case 0 -> {
                            List<class_1657> nearbyPlayers = player.method_37908().method_18464(class_4051.method_36626().method_18418(mobEffectSkill.maxDistanceForEntities).method_36627(), player, player.method_5829().method_1009(mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities));
                            if (!nearbyPlayers.isEmpty()) {
                                for (int i = 0; i < nearbyPlayers.size() && (mobEffectSkill.amountOfEntitiesToApplyTo < 0 || i < mobEffectSkill.amountOfEntitiesToApplyTo); i++) {
                                    nearbyPlayers.get(i).method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), player);
                                }
                            }
                        }
                        case 1 -> {
                            List<class_1308> nearbyMobs = player.method_37908().method_18466(class_1308.class, class_4051.method_36626().method_18418(mobEffectSkill.maxDistanceForEntities).method_36627(), player, player.method_5829().method_1009(mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities));
                            if (!nearbyMobs.isEmpty()) {
                                for (int i = 0; i < nearbyMobs.size() && (mobEffectSkill.amountOfEntitiesToApplyTo < 0 || i < mobEffectSkill.amountOfEntitiesToApplyTo); i++) {
                                    nearbyMobs.get(i).method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), player);
                                }
                            }
                        }
                        case 2 -> {
                            List<class_1308> nearbyMobs = player.method_37908().method_18466(class_1308.class, class_4051.method_36626().method_18418(mobEffectSkill.maxDistanceForEntities).method_36627(), player, player.method_5829().method_1009(mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities));
                            List<class_1657> nearbyPlayers = player.method_37908().method_18464(class_4051.method_36626().method_18418(mobEffectSkill.maxDistanceForEntities).method_36627(), player, player.method_5829().method_1009(mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities, mobEffectSkill.maxDistanceForEntities));
                            List<class_1309> nearbyEntites = new ArrayList<>();
                            nearbyEntites.addAll(nearbyMobs);
                            nearbyEntites.addAll(nearbyPlayers);
                            // sort after distance
                            nearbyEntites.sort((first, second) -> Float.compare(player.method_5739(first), player.method_5739(second)));
                            if (!nearbyEntites.isEmpty()) {
                                for (int i = 0; i < nearbyEntites.size() && (mobEffectSkill.amountOfEntitiesToApplyTo < 0 || i < mobEffectSkill.amountOfEntitiesToApplyTo); i++) {
                                    nearbyMobs.get(i).method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), player);
                                }
                            }
                        }
                    }
                }
            }
        }
    }


    @Unique
    private static Predicate<class_2680> walkers$IS_TALL_GRASS = null;

    @Inject(method = "tick", at = @At("HEAD"))
    private void sheepServerTick(CallbackInfo info) {
        if (walkers$IS_TALL_GRASS == null)
            walkers$IS_TALL_GRASS = class_2715.method_11758(method_37908().method_30349().method_30530(class_7924.field_41254).method_10223(new class_2960("grass")));

        if (!method_37908().field_9236 && this.method_5805()) {
            class_3222 serverPlayer = (class_3222) (Object) this;
            class_1309 shape = PlayerShape.getCurrentShape(serverPlayer);
            if (shape != null && AbilityRegistry.get(shape) instanceof GrassEaterAbility<?> grassEaterAbility) {
                if (grassEaterAbility.eatTick.get(serverPlayer.method_5667()) != null && grassEaterAbility.eatTick.get(serverPlayer.method_5667()) != 0) {
                    grassEaterAbility.eatTick.put(serverPlayer.method_5667(), Math.max(0, grassEaterAbility.eatTick.get(serverPlayer.method_5667()) - 1));

                    if (shape instanceof class_1472 sheepShape)
                        ((SheepAccessor) sheepShape).setEatAnimationTick(grassEaterAbility.eatTick.get(serverPlayer.method_5667()));

                    if (grassEaterAbility.eatTick.get(serverPlayer.method_5667()) == class_3532.method_38788(4, 2)) {
                        class_2338 blockPos = serverPlayer.method_24515();
                        if (walkers$IS_TALL_GRASS.test(method_37908().method_8320(blockPos)) && walkers$isLookingAtPos(blockPos)) {
                            method_37908().method_22352(blockPos, false);

                            method_32876(class_5712.field_28735);
                            serverPlayer.method_7344().method_7585(3, 0.2F);

                            if (shape instanceof class_1472 sheepShape) sheepShape.method_6635(false);
                        } else {
                            class_2338 blockPos2 = blockPos.method_10074();
                            if (method_37908().method_8320(blockPos2).method_27852(class_2246.field_10219) && walkers$isLookingAtPos(blockPos2)) {
                                method_37908().method_20290(class_6088.field_31144, blockPos2, class_2248.method_9507(class_2246.field_10219.method_9564()));
                                method_37908().method_8652(blockPos2, class_2246.field_10566.method_9564(), 2);

                                method_32876(class_5712.field_28735);
                                serverPlayer.method_7344().method_7585(3, 0.1F);

                                if (shape instanceof class_1472 sheepShape) sheepShape.method_6635(false);
                            }
                        }

                    }
                }
            }
        }
    }

    @Unique
    private boolean walkers$isLookingAtPos(class_2338 blockPos) {
        class_1657 player = (class_1657) (Object) this;
        return player.method_5745(2, 0, false) instanceof class_3965 blockHitResult && blockHitResult.method_17777().equals(blockPos);
    }
}
