package tocraft.walkers.mixin.player;

import dev.architectury.event.EventResult;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.event.ShapeEvents;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.mixin.EntityTrackerAccessor;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.RiderSkill;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

@Mixin(class_1657.class)
public abstract class PlayerEntityDataMixin extends class_1309 implements PlayerDataProvider {

    @Shadow
    public abstract void method_5783(class_3414 sound, float volume, float pitch);

    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    private ShapeType<?> walkers$unlocked;
    @Unique
    private int walkers$remainingTime = 0;
    @Unique
    private int walkers$abilityCooldown = 0;
    @Unique
    private class_1309 walkers$shape = null;
    @Unique
    private Optional<UUID> walkers$vehiclePlayerUUID = Optional.empty();

    private PlayerEntityDataMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "readAdditionalSaveData", at = @At("RETURN"))
    private void readNbt(class_2487 tag, CallbackInfo info) {
        // This is the new tag for saving Walkers unlock information.
        // It includes metadata for variants.
        class_2487 unlockedShape = tag.method_10562("UnlockedShape");
        this.walkers$unlocked = ShapeType.from(unlockedShape);

        // Abilities
        walkers$abilityCooldown = tag.method_10550(ABILITY_COOLDOWN_KEY);

        // Hostility
        walkers$remainingTime = tag.method_10550("RemainingHostilityTime");

        // Current Walkers
        walkers$readCurrentShape(tag.method_10562("CurrentShape"));
    }

    @Inject(method = "addAdditionalSaveData", at = @At("RETURN"))
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        // Write 'Unlocked' Walkers data
        class_2487 id = new class_2487();
        if (walkers$unlocked != null)
            id = walkers$unlocked.writeCompound();
        tag.method_10566("UnlockedShape", id);

        // Abilities
        tag.method_10569(ABILITY_COOLDOWN_KEY, walkers$abilityCooldown);

        // Hostility
        tag.method_10569("RemainingHostilityTime", walkers$remainingTime);

        // Current Walkers
        tag.method_10566("CurrentShape", walkers$writeCurrentShape(new class_2487()));
    }

    @Unique
    private class_2487 walkers$writeCurrentShape(class_2487 tag) {
        class_2487 entityTag = new class_2487();

        // serialize current shapeAttackDamage data to tag if it exists
        if (walkers$shape != null) {
            walkers$shape.method_5647(entityTag);
        }

        // put entity type ID under the key "id", or "minecraft:empty" if no shape is
        // equipped (or the shape entity type is invalid)
        tag.method_10582("id",
                walkers$shape == null ? "minecraft:empty" : class_7923.field_41177.method_10221(walkers$shape.method_5864()).toString());
        tag.method_10566("EntityData", entityTag);
        return tag;
    }

    @Unique
    public void walkers$readCurrentShape(class_2487 tag) {
        Optional<class_1299<?>> type = class_1299.method_17684(tag);

        // set shape to null (no shape) if the entity id is "minecraft:empty"
        if (tag.method_10558("id").equals("minecraft:empty")) {
            this.walkers$shape = null;
            ((DimensionsRefresher) this).shape_refreshDimensions();
        }

        // if entity type was valid, deserialize entity data from tag
        else if (type.isPresent()) {
            class_2487 entityTag = tag.method_10562("EntityData");

            // ensure entity data exists
            if (!entityTag.method_33133()) {
                if (walkers$shape == null || !type.get().equals(walkers$shape.method_5864())) {
                    walkers$shape = (class_1309) type.get().method_5883(method_37908());

                    // refresh player dimensions/hitbox on client
                    ((DimensionsRefresher) this).shape_refreshDimensions();
                }

                walkers$shape.method_5651(entityTag);
            }
        }
    }

    @Unique
    @Override
    public ShapeType<?> walkers$get2ndShape() {
        return walkers$unlocked;
    }

    @Override
    public void walkers$set2ndShape(ShapeType<?> unlocked) {
        this.walkers$unlocked = unlocked;
    }

    @Unique
    @Override
    public int walkers$getRemainingHostilityTime() {
        return walkers$remainingTime;
    }

    @Unique
    @Override
    public void walkers$setRemainingHostilityTime(int max) {
        walkers$remainingTime = max;
    }

    @Unique
    @Override
    public int walkers$getAbilityCooldown() {
        return walkers$abilityCooldown;
    }

    @Unique
    @Override
    public void walkers$setAbilityCooldown(int abilityCooldown) {
        this.walkers$abilityCooldown = abilityCooldown;
    }

    @Unique
    @Override
    public class_1309 walkers$getCurrentShape() {
        return walkers$shape;
    }

    @Unique
    @Override
    public void walkers$setCurrentShape(class_1309 shape) {
        this.walkers$shape = shape;
    }

    @SuppressWarnings("ConstantConditions")
    @Unique
    @Override
    public boolean walkers$updateShapes(@Nullable class_1309 shape) {
        class_1657 player = (class_1657) (Object) this;
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        EventResult result = ShapeEvents.SWAP_SHAPE.invoker().swap((class_3222) player, shape);
        if (result.isFalse()) {
            return false;
        }

        this.walkers$shape = shape;

        // refresh entity hitbox dimensions
        ((DimensionsRefresher) player).shape_refreshDimensions();

        // shape is valid and scaling health is on; set entity's max health and current
        // health to reflect shape.
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                // calculate the current health in percentage, used later
                float currentHealthPercent = player.method_6032() / player.method_6063();

                healthAttribute.method_6192(Math.min(Walkers.CONFIG.maxHealth, shape.method_6063()));

                // set health
                if (Walkers.CONFIG.percentScalingHealth)
                    player.method_6033(Math.min(currentHealthPercent * player.method_6063(), player.method_6063()));
                else
                    player.method_6033(Math.min(player.method_6032(), player.method_6063()));
            }
        }

        // If the shape is null (going back to player), set the player's base health
        // value to 20 (default) to clear old changes.
        if (shape == null) {
            float currentHealthPercent = player.method_6032() / player.method_6063();

            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                healthAttribute.method_6192(20);
            }

            // Clear health value if needed
            if (Walkers.CONFIG.percentScalingHealth)
                player.method_6033(Math.min(currentHealthPercent * player.method_6063(), player.method_6063()));
            else
                player.method_6033(Math.min(player.method_6032(), player.method_6063()));
        }

        // update flight properties on player depending on shape
        class_3222 serverPlayer = (class_3222) player;
        if (Walkers.hasFlyingPermissions((class_3222) player)) {
            FlightHelper.grantFlightTo(serverPlayer);
            player.method_31549().method_7248(Walkers.CONFIG.flySpeed);
            player.method_7355();
        } else if (!player.method_7337()) {
            FlightHelper.revokeFlight(serverPlayer);
            player.method_31549().method_7248(0.05f);
            player.method_7355();
        }

        // If the player is riding a Ravager and changes into a Walkers that cannot
        // ride Ravagers, kick them off.
        if (player.method_5854() instanceof class_1309 livingVehicle) {
            // checks, if the player can continue riding
            boolean b1 = false;
            boolean b2 = false;
            for (RiderSkill<?> riderSkill : SkillRegistry.get(shape, RiderSkill.ID).stream().map(entry -> (RiderSkill<?>) entry).toList()) {
                if (riderSkill.isRideable(livingVehicle) || (livingVehicle instanceof class_1657 rideablePlayer && riderSkill.isRideable(PlayerShape.getCurrentShape(rideablePlayer)))) {
                    b1 = true;
                    b2 = true;
                }
                if (b2) break;
            }
            if (!b1) {
                player.method_5848();
            }
        }

        // If the player is riding another Player that switches into another shape that cannot
        // be ridden, the riding player stops riding
        if (!(shape instanceof class_1496)) {
            for (class_1297 passenger : player.method_5685()) {
                passenger.method_5848();
            }
        }

        // sync with client
        if (!player.method_37908().field_9236) {
            PlayerShape.sync((class_3222) player);

            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor) ((class_3218) player.method_37908())
                    .method_14178().field_17254).getEntityMap();
            Object tracking = trackers.get(player.method_5628());
            ((EntityTrackerAccessor) tracking).getSeenBy().forEach(
                    listener -> PlayerShape.sync((class_3222) player, listener.method_32311())
            );
        }

        return true;
    }

    @Unique
    @Override
    public Optional<UUID> walkers$getVehiclePlayerUUID() {
        return walkers$vehiclePlayerUUID;
    }

    @Unique
    @Override
    public void walkers$setVehiclePlayerUUID(UUID riddenPlayerUUID) {
        walkers$vehiclePlayerUUID = Optional.ofNullable(riddenPlayerUUID);
    }
}
