package tocraft.walkers.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_5635;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.WalkOnPowderSnow;

@Mixin(class_5635.class)
public class PowderSnowBlockMixin {
    @Inject(method = "canEntityWalkOnPowderSnow", at = @At("RETURN"), cancellable = true)
    private static void handleWalkOnPowderSnowSkill(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValue() && entity instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null && SkillRegistry.has(shape, WalkOnPowderSnow.ID)) {
                cir.setReturnValue(true);
            }
        }
    }
}
