package tocraft.walkers.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_4140;
import net.minecraft.class_5418;
import net.minecraft.class_5420;

@Mixin(class_5420.class)
public class PiglinBruteBrainMixin {

    @Inject(method = "getTargetIfWithinRange", at = @At("RETURN"), cancellable = true)
    private static void getTargetIfWithinRange(class_5418 piglinBrute, class_4140<? extends class_1309> memoryType, CallbackInfoReturnable<Optional<? extends class_1309>> cir) {
        cir.setReturnValue(piglinBrute.method_18868().method_18904(memoryType).filter((livingEntity) -> {
            if (livingEntity instanceof class_1657 player) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                if (shape != null) {
                    // Piglins should not attack Piglins or Piglin Brutes, unless they have
                    // hostility
                    if (shape instanceof class_5418) {
                        return false;
                    }

                    // Player has a shape but is not a piglin, check config for what to do
                    else {
                        if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && shape instanceof class_1569) {
                            // Check hostility for aggro on non-piglin hostiles
                            if (!PlayerHostility.hasHostility(player)) {
                                return false;
                            }
                        }
                    }
                }
            }
            return livingEntity.method_24516(piglinBrute, 12.0);
        }));
    }
}