package tocraft.walkers.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.world.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.HumanoidSkill;
import tocraft.walkers.skills.impl.NoPhysicsSkill;

@SuppressWarnings("ConstantConditions")
@Mixin(class_1297.class)
public abstract class EntityMixin implements DimensionsRefresher {

    @Shadow
    private class_4048 dimensions;

    @Shadow
    public abstract class_4050 getPose();

    @Shadow
    public abstract class_4048 getDimensions(class_4050 pose);

    @Shadow
    public abstract class_238 getBoundingBox();

    @Shadow
    public abstract void setBoundingBox(class_238 boundingBox);

    @Shadow
    protected boolean firstTick;

    @Shadow
    public abstract void move(class_1313 type, class_243 movement);

    @Shadow
    private float eyeHeight;

    @Shadow
    protected abstract float getEyeHeight(class_4050 pose, class_4048 dimensions);

    @Shadow
    public abstract boolean isCrouching();

    @Inject(method = "getBbWidth", at = @At("HEAD"), cancellable = true)
    private void getBbWidth(CallbackInfoReturnable<Float> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_17681());
            }
        }
    }

    @Inject(method = "getBbHeight", at = @At("HEAD"), cancellable = true)
    private void getBbHeight(CallbackInfoReturnable<Float> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_17682());
            }
        }
    }

    @Override
    public void shape_refreshDimensions() {
        class_4048 currentDimensions = this.dimensions;
        class_4050 entityPose = this.getPose();
        class_4048 newDimensions = this.getDimensions(entityPose);

        this.dimensions = newDimensions;
        this.eyeHeight = this.getEyeHeight(entityPose, newDimensions);

        class_238 box = this.getBoundingBox();
        this.setBoundingBox(new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1323 + newDimensions.field_18067, box.field_1322 + newDimensions.field_18068, box.field_1321 + newDimensions.field_18067));

        if (!this.firstTick) {
            float f = currentDimensions.field_18067 - newDimensions.field_18067;
            this.move(class_1313.field_6308, new class_243(f, 0.0D, f));
        }
    }

    @Inject(at = @At("HEAD"), method = "getEyeHeight()F", cancellable = true)
    public void getEyeHeight(CallbackInfoReturnable<Float> cir) {
        if ((class_1297) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                if (this.isCrouching() && SkillRegistry.has(shape, HumanoidSkill.ID)) {
                    cir.setReturnValue(shape.method_18381(class_4050.field_18081) * 1.27F / 1.62F);
                    return;
                }
                cir.setReturnValue(shape.method_5751());
            }
        }
    }

    @Inject(method = "fireImmune", at = @At("HEAD"), cancellable = true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_5864().method_19946());
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void goThroughBlocks(CallbackInfo ci) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null) {
                if (SkillRegistry.has(shape, NoPhysicsSkill.ID)) {
                    player.field_5960 = true;
                }
            }
        }
    }
}
