package tocraft.walkers.integrations.impl;

import tocraft.walkers.Walkers;
import tocraft.walkers.integrations.AbstractIntegration;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.PreySkill;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1569;
import net.minecraft.class_2960;

public class GuardVillagersIntegration extends AbstractIntegration {
    public static final String MODID = "guardvillagers";
    public static final class_2960 GUARD_VILLAGER_TYPE = new class_2960(MODID, "guard");

    @Override
    public void initialize() {
        SkillRegistry.registerByPredicate(entity -> entity instanceof class_1569 && !getMobBlackList().contains(entity.method_5653()), new PreySkill<>(List.of(hunter -> class_1299.method_5890(hunter.method_5864()).equals(GUARD_VILLAGER_TYPE))));
    }

    private static List<String> CACHED_MOB_BLACKLIST = new ArrayList<>();

    @SuppressWarnings("unchecked")
    private static List<String> getMobBlackList() {
        try {
            Class<?> configClass = Class.forName("tallestegg.guardvillagers.configuration.GuardConfig");
            Object mobBlackListObject = configClass.getField("MobBlackList").get(configClass.getDeclaredConstructor().newInstance());
            if (mobBlackListObject instanceof List) {
                CACHED_MOB_BLACKLIST = (List<String>) mobBlackListObject;
                return CACHED_MOB_BLACKLIST;
            }
        } catch (ClassNotFoundException | NoSuchMethodException | IllegalAccessException |
                 InvocationTargetException |
                 NoSuchFieldException | InstantiationException e) {
            Walkers.LOGGER.error("{}: failed to get the mob blacklist for {}: {}", GuardVillagersIntegration.class.getSimpleName(), MODID, e);
        }

        return CACHED_MOB_BLACKLIST;
    }
}
