package tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import tocraft.walkers.api.variant.TypeProvider;

import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7102;
import net.minecraft.class_7923;

public class FrogTypeProvider extends TypeProvider<class_7102> {

    private static final Map<Integer, String> PREFIX_BY_ID = ImmutableMap
            .<Integer, String>builder()
            .put(0, "Temperate")
            .put(1, "Warm")
            .put(2, "Cold")
            .build();

    @Override
    public int getVariantData(class_7102 entity) {
        return class_7923.field_41164.method_10206(entity.method_41354());
    }

    @Override
    public class_7102 create(class_1299<class_7102> type, class_1937 world, int data) {
        class_7102 frog = new class_7102(type, world);
        frog.method_41353(class_7923.field_41164.method_10200(data));
        return frog;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return 2;
    }

    @Override
    public class_2561 modifyText(class_7102 frog, class_5250 text) {
        int variant = getVariantData(frog);
        return class_2561.method_43470(PREFIX_BY_ID.containsKey(variant) ? PREFIX_BY_ID.get(variant) + " " : "").method_10852(text);
    }
}
