package tocraft.walkers.fabric.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;

@SuppressWarnings("ConstantConditions")
@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @WrapWithCondition(method = "baseTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;setAirSupply(I)V", ordinal = 2))
    private boolean cancelAirIncrement(class_1309 livingEntity, int air) {
        // Aquatic creatures should not regenerate breath on land
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                return Walkers.isAquatic(shape) >= 2;
            }
        }
        return true;
    }
}
