package tocraft.walkers.command;

import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;

public class WalkersCommand {

    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, ctx, b) -> {
            LiteralCommandNode<class_2168> rootNode = class_2170.method_9247("walkers")
                    .requires(source -> source.method_9259(2)).build();

            /*
             * Used to remove the second shape of the specified Player.
             */
            LiteralCommandNode<class_2168> remove2ndShape = class_2170.method_9247("remove2ndShape")
                    .then(class_2170.method_9244("player", class_2186.method_9308()).executes(context -> {
                        remove2ndShape(context.getSource(), class_2186.method_9315(context, "player"));
                        return 1;
                    })).build();

            /*
             * Used to give the specified shape to the specified Player.
             */
            LiteralCommandNode<class_2168> change2ndShape = class_2170.method_9247("change2ndShape")
                    .then(class_2170.method_9244("player", class_2186.method_9308())
                            .then(class_2170.method_9244("shape", class_7733.method_45603(ctx, class_7924.field_41266))
                                    .suggests(class_2321.field_10935).executes(context -> {
                                        change2ndShape(context.getSource(), class_2186.method_9315(context, "player"),
                                                class_1299.method_5890(class_7733
                                                        .method_45610(context, "shape").comp_349()),
                                                null);
                                        return 1;
                                    }).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                            .executes(context -> {
                                                class_2487 nbt = class_2179.method_9285(context, "nbt");

                                                change2ndShape(context.getSource(),
                                                        class_2186.method_9315(context, "player"),
                                                        class_1299.method_5890(class_7733
                                                                .method_45610(context, "shape").comp_349()),
                                                        nbt);

                                                return 1;
                                            }))))
                    .build();

            LiteralCommandNode<class_2168> switchShape = class_2170.method_9247("switchShape").then(class_2170.method_9244("player", class_2186.method_9308()).then(class_2170.method_9247("normal").executes(context -> {
                        switchShapeToNormal(context.getSource(), class_2186.method_9315(context, "player"));
                        return 1;
                    })).then(class_2170.method_9244("shape", class_7733.method_45603(ctx, class_7924.field_41266))
                            .suggests(class_2321.field_10935).executes(context -> {
                                switchShape(context.getSource(), class_2186.method_9315(context, "player"),
                                        class_1299.method_5890(
                                                class_7733.method_45610(context, "shape").comp_349()),
                                        null);

                                return 1;
                            }).then(class_2170.method_9244("nbt", class_2179.method_9284()).executes(context -> {
                                class_2487 nbt = class_2179.method_9285(context, "nbt");

                                switchShape(context.getSource(), class_2186.method_9315(context, "player"),
                                        class_1299.method_5890(
                                                class_7733.method_45610(context, "shape").comp_349()),
                                        nbt);

                                return 1;
                            }))))
                    .build();

            LiteralCommandNode<class_2168> show2ndShape = class_2170.method_9247("show2ndShape")
                    .then(class_2170.method_9244("player", class_2186.method_9305())
                            .executes(context -> show2ndShape(context.getSource(), class_2186.method_9315(context, "player"))))
                    .build();

            rootNode.addChild(remove2ndShape);
            rootNode.addChild(change2ndShape);
            rootNode.addChild(switchShape);
            rootNode.addChild(show2ndShape);

            rootNode.addChild(BlacklistCommands.getRootNode());

            dispatcher.getRoot().addChild(rootNode);
        });
    }

    private static int show2ndShape(class_2168 source, class_3222 player) {

        if (((PlayerDataProvider) player).walkers$get2ndShape() != null) {
            ShapeType<?> type = ((PlayerDataProvider) player).walkers$get2ndShape();
            source.method_45068(class_2561.method_43469("walkers.show2ndShapeNot_positive",
                    player.method_5476(), ShapeType.createTooltipText(type.create(player.method_37908(), player))));

            return 1;
        } else {
            source.method_45068(class_2561.method_43469("walkers.show2ndShapeNot_failed", player.method_5476()));
        }

        return 0;
    }

    private static void remove2ndShape(class_2168 source, class_3222 player) {

        boolean result = PlayerShapeChanger.change2ndShape(player, null);

        if (result) {
            player.method_7353(class_2561.method_43471("walkers.remove_entity"), true);
            source.method_45068(class_2561.method_43469("walkers.deletion_success", player.method_5476()));
        }
    }

    @SuppressWarnings("unchecked")
    private static void change2ndShape(class_2168 source, class_3222 player, class_2960 id,
                                       @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = ShapeType.from((class_1299<class_1309>) class_7923.field_41177.method_10223(id));
        class_2561 name = class_2561.method_43471(type.getEntityType().method_5882());

        // If the specified granting NBT is not null, change the ShapeType to reflect
        // potential variants.
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_9225();
            class_1297 loaded = class_1299.method_17842(copy, serverWorld, it -> it);
            if (loaded instanceof class_1309 living) {
                type = ShapeType.from(living);
                name = ShapeType.createTooltipText(living);
            }
        }

        if (((PlayerDataProvider) player).walkers$get2ndShape() != type) {
            boolean result = PlayerShapeChanger.change2ndShape(player, type);

            if (result) {
                player.method_43496(class_2561.method_43469("walkers.unlock_entity", name));
                source.method_45068(
                        class_2561.method_43469("walkers.grant_success", name, player.method_5476()));
            }
        } else {
            source.method_45068(class_2561.method_43469("walkers.already_has", player.method_5476(), name));
        }
    }

    private static void switchShape(class_2168 source, class_3222 player, class_2960 shape, @Nullable class_2487 nbt) {
        class_1297 created;

        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", shape.toString());
            class_3218 serverWorld = source.method_9225();
            created = class_1299.method_17842(copy, serverWorld, it -> it);
        } else {
            class_1299<?> entity = class_7923.field_41177.method_10223(shape);
            created = entity.method_5883(player.method_37908());
        }

        if (created instanceof class_1309) {
            boolean result = PlayerShape.updateShapes(player, (class_1309) created);
            if (result) {
                source.method_45068(class_2561.method_43469("walkers.switchShape_success",
                        player.method_5476(), class_2561.method_43471(created.method_5864().method_5882())));
            }
        }
    }

    private static void switchShapeToNormal(class_2168 source, class_3222 player) {
        boolean result = PlayerShape.updateShapes(player, null);

        if (result) {
            source.method_45068(
                    class_2561.method_43469("walkers.switchShape_human_success", player.method_5476()));
        }
    }
}
