package tocraft.walkers.api.variant;

import org.jetbrains.annotations.Nullable;
import tocraft.walkers.impl.variant.*;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;

public class TypeProviderRegistry {
    public static final Map<class_1299<? extends class_1309>, TypeProvider<? extends class_1309>> VARIANT_BY_TYPE = new LinkedHashMap<>();

    static {
        register(class_1299.field_6115, new SheepTypeProvider());
        register(class_1299.field_28315, new AxolotlTypeProvider());
        register(class_1299.field_6104, new ParrotTypeProvider());
        register(class_1299.field_17943, new FoxTypeProvider());
        register(class_1299.field_16281, new CatTypeProvider());
        register(class_1299.field_6069, new SlimeTypeProvider());
        register(class_1299.field_37419, new FrogTypeProvider());
        register(class_1299.field_6139, new HorseTypeProvider());
        register(class_1299.field_6074, new LlamaTypeProvider<>());
        register(class_1299.field_17714, new LlamaTypeProvider<>());
        register(class_1299.field_30052, new GoatTypeProvider());
        register(class_1299.field_6102, new MagmaCubeTypeProvider());
        register(class_1299.field_6143, new MushroomCowTypeProvider());
        register(class_1299.field_6146, new PandaTypeProvider());
        register(class_1299.field_6140, new RabbitTypeProvider());
        register(class_1299.field_6077, new VillagerTypeProvider());
        register(class_1299.field_6054, new ZombieVillagerTypeProvider());
        register(class_1299.field_6111, new TropicalFishTypeProvider());
        register(class_1299.field_6109, new ShulkerTypeProvider());
    }

    public static <T extends class_1309> void register(class_1299<T> type, TypeProvider<T> provider) {
        VARIANT_BY_TYPE.put(type, provider);
    }

    public static <T extends class_1309> boolean hasProvider(class_1299<T> type) {
        return VARIANT_BY_TYPE.containsKey(type);
    }

    @SuppressWarnings("unchecked")
    @Nullable
    public static <T extends class_1309> TypeProvider<T> getProvider(class_1299<T> type) {
        return (TypeProvider<T>) VARIANT_BY_TYPE.get(type);
    }
}
