package tocraft.walkers.api.variant;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.blacklist.EntityBlacklist;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@SuppressWarnings({"unchecked", "unused"})
public class ShapeType<T extends class_1309> {

    private static final List<class_1299<? extends class_1309>> LIVING_TYPE_CASH = new ArrayList<>();
    private final class_1299<T> type;
    private final int variantData;

    public static <Z extends class_1309> int getDefaultVariantData(class_1299<Z> type) {
        TypeProvider<Z> provider = TypeProviderRegistry.getProvider(type);
        if (provider != null) {
            return provider.getFallbackData();
        } else {
            return -1;
        }
    }

    public ShapeType(class_1299<T> type) {
        this(type, getDefaultVariantData(type));
    }

    public ShapeType(class_1299<T> type, int variantData) {
        this.type = type;
        this.variantData = variantData;
    }

    public ShapeType(T entity) {
        this.type = (class_1299<T>) entity.method_5864();

        // Discover variant data based on entity NBT data.
        @Nullable
        TypeProvider<T> provider = TypeProviderRegistry.getProvider(type);
        if (provider != null) {
            variantData = provider.getVariantData(entity);
        } else {
            variantData = getDefaultVariantData(type);
        }
    }

    public static <Z extends class_1309> @NotNull ShapeType<Z> from(class_1299<Z> entityType) {
        return new ShapeType<>(entityType, getDefaultVariantData(entityType));
    }

    @Nullable
    public static <Z extends class_1309> ShapeType<Z> from(Z entity) {
        if (entity == null) {
            return null;
        }

        return new ShapeType<>(entity);
    }

    @Nullable
    public static ShapeType<?> from(class_2487 compound) {
        class_2960 id = new class_2960(compound.method_10558("EntityID"));
        if (!class_7923.field_41177.method_10250(id)) {
            return null;
        }

        return from((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(id),
                compound.method_10545("Variant") ? compound.method_10550("Variant") : -1);
    }

    @Nullable
    public static <Z extends class_1309> ShapeType<Z> from(class_1299<Z> entityType, int variant) {
        TypeProvider<Z> typeProvider = TypeProviderRegistry.getProvider(entityType);
        if (typeProvider != null) {
            if (variant < -1 || variant > typeProvider.getRange()) {
                return null;
            }
        }

        return new ShapeType<>(entityType, variant);
    }

    public static <T extends class_1309> List<ShapeType<T>> getAllTypes(class_1299<T> entityType) {
        List<ShapeType<T>> types = new ArrayList<>();
        // check blacklist
        if (!EntityBlacklist.isBlacklisted(entityType)) {
            // check variants
            TypeProvider<?> variant = TypeProviderRegistry.getProvider(entityType);
            if (variant != null) {
                for (int i = 0; i <= variant.getRange(); i++) {
                    types.add(new ShapeType<>(entityType, i));
                }
            } else {
                types.add(ShapeType.from(entityType));
            }
        }
        return types;
    }

    public static List<ShapeType<?>> getAllTypes(class_1937 world) {
        if (LIVING_TYPE_CASH.isEmpty()) {
            for (class_1299<?> type : class_7923.field_41177) {
                try {
                    class_1297 instance = type.method_5883(world);
                    if (instance instanceof class_1309) {
                        LIVING_TYPE_CASH.add((class_1299<? extends class_1309>) type);
                    }
                } catch (Exception e) {
                    Walkers.LOGGER.error(e.getLocalizedMessage());
                }
            }
        }

        List<ShapeType<? extends class_1309>> types = new ArrayList<>();
        for (class_1299<? extends class_1309> type : LIVING_TYPE_CASH) {
            types.addAll(getAllTypes(type));
        }

        return types;
    }

    public class_2487 writeCompound() {
        class_2487 compound = new class_2487();
        compound.method_10582("EntityID", class_7923.field_41177.method_10221(type).toString());
        compound.method_10569("Variant", variantData);
        return compound;
    }

    public class_1299<? extends class_1309> getEntityType() {
        return type;
    }

    public T create(class_1937 world) {
        TypeProvider<T> typeProvider = TypeProviderRegistry.getProvider(type);
        if (typeProvider != null) {
            return typeProvider.create(type, world, variantData);
        }

        return type.method_5883(world);
    }

    /**
     * Create the entity based on player data
     */
    public T create(class_1937 world, class_1657 player) {
        TypeProvider<T> typeProvider = TypeProviderRegistry.getProvider(type);
        if (typeProvider != null) {
            return typeProvider.create(type, world, variantData, player);
        }

        return type.method_5883(world);
    }

    public int getVariantData() {
        return variantData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        ShapeType<?> that = (ShapeType<?>) o;
        return variantData == that.variantData && type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, variantData);
    }

    public static <L extends class_1309> class_2561 createTooltipText(L entity) {
        TypeProvider<L> provider = TypeProviderRegistry.getProvider((class_1299<L>) entity.method_5864());
        if (provider != null) {
            return provider.modifyText(entity, class_2561.method_43471(entity.method_5864().method_5882()));
        }

        return class_2561.method_43471(entity.method_5864().method_5882());
    }
}
