package tocraft.walkers.api.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_3545;
import net.minecraft.class_4041;
import net.minecraft.class_4791;
import net.minecraft.class_4997;
import net.minecraft.class_549;
import net.minecraft.class_555;
import net.minecraft.class_562;
import net.minecraft.class_571;
import net.minecraft.class_574;
import net.minecraft.class_578;
import net.minecraft.class_582;
import net.minecraft.class_583;
import net.minecraft.class_586;
import net.minecraft.class_587;
import net.minecraft.class_590;
import net.minecraft.class_597;
import net.minecraft.class_610;
import net.minecraft.class_611;
import net.minecraft.class_617;
import net.minecraft.class_624;
import net.minecraft.class_630;
import net.minecraft.class_7280;
import net.minecraft.class_7308;
import net.minecraft.class_7751;
import net.minecraft.client.model.*;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.math.math;
import tocraft.walkers.api.model.impl.GenericEntityArm;
import tocraft.walkers.mixin.client.accessor.*;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@Environment(EnvType.CLIENT)
public class EntityArms {

    private static final Map<class_1299<? extends class_1309>, class_3545<EntityArmProvider<? extends class_1309>, ArmRenderingManipulator<?>>> DIRECT_PROVIDERS = new LinkedHashMap<>();
    private static final Map<Class<?>, class_3545<ClassArmProvider<?>, ArmRenderingManipulator<?>>> CLASS_PROVIDERS = new LinkedHashMap<>();

    /**
     * non-specific, for easy use
     */
    public static <T extends class_1309> void register(class_1299<T> type, EntityArmProvider<T> provider) {
        register(type, provider, (stack, model) -> {
        });
    }

    /**
     * type-based, with optional manipulator
     */
    public static <T extends class_1309> void register(class_1299<T> type, EntityArmProvider<T> provider,
                                                         ArmRenderingManipulator<class_583<T>> manipulator) {
        DIRECT_PROVIDERS.put(type, new class_3545<>(provider, manipulator));
    }

    /**
     * Specific, but for easy use
     */
    public static <T extends class_583<?>> void register(Class<T> modelClass, ClassArmProvider<T> provider) {
        register(modelClass, provider, (stack, model) -> {
        });
    }

    /**
     * Specific with optional manipulator
     */
    public static <T extends class_583<?>> void register(Class<T> modelClass, ClassArmProvider<T> provider,
                                                           ArmRenderingManipulator<T> manipulator) {
        CLASS_PROVIDERS.put(modelClass, new class_3545<>(provider, manipulator));
    }

    @Nullable
    @SuppressWarnings("unchecked")
    public static <T extends class_1309> class_3545<class_630, ArmRenderingManipulator<?>> get(T entity,
                                                                                            class_583<T> model) {
        // done to bypass type issues
        class_3545<EntityArmProvider<? extends class_1309>, ArmRenderingManipulator<?>> before = DIRECT_PROVIDERS
                .get(entity.method_5864());

        // Direct entity type provider was found, return it now
        if (before != null) {
            class_3545<EntityArmProvider<T>, ArmRenderingManipulator<?>> provider = new class_3545<>(
                    (EntityArmProvider<T>) before.method_15442(), before.method_15441());
            return new class_3545<>(provider.method_15442().getArm(entity, model), provider.method_15441());
        } else {
            Optional<class_3545<ClassArmProvider<?>, ArmRenderingManipulator<?>>> beforeClassProvider = CLASS_PROVIDERS
                    .entrySet().stream().filter(pair ->
                            pair.getKey().isInstance(model))
                    .findFirst().map(entry ->
                            new class_3545<>(entry.getValue().method_15442(), entry.getValue().method_15441())
                    );

            // fall back to class providers
            if (beforeClassProvider.isPresent()) {
                class_3545<ClassArmProvider<class_583<?>>, ArmRenderingManipulator<class_583<class_1309>>> classProvider = new class_3545<>(
                        (ClassArmProvider<class_583<?>>) beforeClassProvider.get().method_15442(),
                        (ArmRenderingManipulator<class_583<class_1309>>) beforeClassProvider.get().method_15441());
                return new class_3545<>(classProvider.method_15442().getArm(entity, model), classProvider.method_15441());
            } else {
                return null;
            }
        }
    }

    @Nullable
    @SuppressWarnings("unchecked")
    public static <T extends class_1309> EntityArmProvider<T> get(class_1299<class_1309> type) {
        return (EntityArmProvider<T>) DIRECT_PROVIDERS.get(type);
    }

    @Nullable
    @SuppressWarnings("unchecked")
    public static <T extends class_1309> EntityArmProvider<T> get(
            Class<class_583<? extends class_1309>> modelClass) {
        return (EntityArmProvider<T>) CLASS_PROVIDERS.get(modelClass);
    }

    public static void init() {
        // specific
        register(class_578.class, (llama, model) -> ((LlamaEntityModelAccessor) model).getRightFrontLeg());
        register(class_586.class, (panda, model) -> ((QuadrupedEntityModelAccessor) model).getRightFrontLeg(),
                (stack, model) -> stack.method_22904(0, -0.5, 0));
        register(class_555.class, (blaze, model) -> ((BlazeEntityModelAccessor) model).getUpperBodyParts()[10],
                (stack, model) -> {
                    stack.method_22907(math.getDegreesQuaternion(math.POSITIVE_Z(), 45));
                    stack.method_22907(math.getDegreesQuaternion(math.POSITIVE_Y(), -15));
                    stack.method_22907(math.getDegreesQuaternion(math.POSITIVE_X(), -25));
                    stack.method_22904(0, 0, -.25);
                });
        register(class_582.class, (ocelot, model) -> ((OcelotEntityModelAccessor) model).getRightFrontLeg());
        register(class_611.class, (spider, model) -> ((SpiderEntityModelAccessor) model).getRightFrontLeg(),
                (stack, model) -> {
                    stack.method_22907(math.getDegreesQuaternion(math.POSITIVE_Y(), -15));
                    stack.method_22907(math.getDegreesQuaternion(math.POSITIVE_X(), 15));
                    stack.method_46416(0, 0, 0);
                });
        register(class_574.class,
                (golem, model) -> model.method_2809(),
                (stack, model) -> stack.method_22904(0, 0, -.5));
        register(class_587.class,
                (pig, model) -> ((QuadrupedEntityModelAccessor) model).getRightFrontLeg(),
                (stack, model) -> stack.method_22904(0, 0, .6));
        register(class_590.class,
                (bear, model) -> ((QuadrupedEntityModelAccessor) model).getRightFrontLeg(),
                (stack, model) -> stack.method_22904(0, 0, .3));
        register(class_571.class,
                (bear, model) -> ((RavagerEntityModelAccessor) model).getRightFrontLeg());
        register(class_610.class,
                (squid, model) -> ((SquidEntityModelAccessor) model).getTentacles()[0]);

        // something between specific & generic
        register(class_549.class, new GenericEntityArm<>(),
                (stack, model) -> {
                    stack.method_22907(math.getDegreesQuaternion(math.POSITIVE_Y(), -15));
                    stack.method_22904(0, -.25, .25);
                });
        register(class_7751.class, new GenericEntityArm<>(),
                (stack, model) -> stack.method_22904(0, -.25, 0));
        register(class_4041.class, new GenericEntityArm<>(),
                (stack, model) -> stack.method_22904(0, -0.1, 0));
        register(class_624.class, new GenericEntityArm<>(),
                (stack, model) -> stack.method_22904(0, -0.1, 0));
        register(class_4997.class, new GenericEntityArm<>("right_leg"));
        register(class_7280.class, new GenericEntityArm<>("bone", "body", "right_arm"),
                ((stack, model) -> {
                    stack.method_22905(.5f, .5f, .5f);
                    stack.method_22904(0, .75, -1);
                }));
        register(class_7308.class, new GenericEntityArm<>("root", "body", "right_arm"),
                (stack, model) -> {
                    stack.method_22905(5, 5, 5);
                    stack.method_22904(.2, .5, -.35);
                });
        register(class_617.class, new GenericEntityArm<>("root", "body", "right_arm"),
                (stack, model) -> {
                    stack.method_22905(5, 5, 5);
                    stack.method_22904(.2, .5, -.35);
                });
        register(class_562.class, new GenericEntityArm<>(),
                (stack, model) -> stack.method_22904(0, -.5, 0));
        register(class_4791.class, new GenericEntityArm<>(),
                (stack, model) -> stack.method_22905(.75f, .75f, .75f));

        // generic
        register(class_597.class,
                (quad, model) -> ((QuadrupedEntityModelAccessor) model).getRightFrontLeg());

        // types
        register(class_1299.field_6105,
                (pillager, model) -> ((IllagerEntityModelAccessor) model).getRightArm(),
                (stack, model) -> {
                    stack.method_22907(math.getDegreesQuaternion(math.POSITIVE_X(), -10));
                    stack.method_22904(0, .5, -.3);
                });
    }
}
