package tocraft.walkers.api.data.skills;

import com.google.gson.*;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import tocraft.walkers.Walkers;
import tocraft.walkers.skills.ShapeSkill;
import tocraft.walkers.skills.SkillRegistry;

import java.util.*;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class SkillDataManager extends class_4309 {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, new class_2960.class_2961()).create();

    public SkillDataManager() {
        super(GSON, Walkers.MODID + "/skills");
    }

    @SuppressWarnings("unchecked")
    @Override
    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            Map<Pair<class_2960, class_2960>, List<? extends ShapeSkill<?>>> skillMap = skillEntryFromJson(mapEntry.getValue().getAsJsonObject());

            if (!skillMap.isEmpty()) {
                for (Map.Entry<Pair<class_2960, class_2960>, List<? extends ShapeSkill<?>>> entitySkills : skillMap.entrySet()) {
                    for (ShapeSkill<?> shapeSkill : entitySkills.getValue()) {
                        if (class_7923.field_41177.method_10250(entitySkills.getKey().getFirst())) {
                            SkillRegistry.registerByType((class_1299<class_1309>) class_7923.field_41177.method_10223(entitySkills.getKey().getFirst()), (ShapeSkill<class_1309>) shapeSkill);
                        } else if (entitySkills.getKey().getSecond() != null) {
                            SkillRegistry.registerByTag(class_6862.method_40092(class_7924.field_41266, entitySkills.getKey().getSecond()), (ShapeSkill<class_1309>) shapeSkill);
                        }
                    }
                    String key = entitySkills.getKey().getFirst() != null ? entitySkills.getKey().getFirst().toString() : entitySkills.getKey().getSecond().toString();
                    Walkers.LOGGER.info("{}: {} registered for {}", getClass().getSimpleName(), key, entitySkills.getValue().stream().map(skill -> skill.getClass().getSimpleName()).toArray(String[]::new));
                }
            }
        }
    }

    protected static Map<Pair<class_2960, class_2960>, List<? extends ShapeSkill<?>>> skillEntryFromJson(JsonObject json) {
        Codec<Map<Pair<class_2960, class_2960>, List<? extends ShapeSkill<?>>>> codec = RecordCodecBuilder.create((instance) -> instance.group(
                Codec.list(class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList<>()).forGetter(o -> o.keySet().stream().map(Pair::getFirst).toList()),
                Codec.list(class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList<>()).forGetter(o -> o.keySet().stream().map(Pair::getSecond).toList()),
                Codec.STRING.optionalFieldOf("required_mod", "").forGetter(o -> ""),
                Codec.list(byNameCodec()).fieldOf("skills").forGetter(o -> new ArrayList<>())
        ).apply(instance, instance.stable((entityTypes, entityTags, requiredMod, shapeSkills) -> {
            Map<Pair<class_2960, class_2960>, List<? extends ShapeSkill<?>>> skillMap = new HashMap<>();
            if (requiredMod.isBlank() || Platform.isModLoaded(requiredMod)) {
                for (class_2960 entityType : entityTypes) {
                    skillMap.put(new Pair<>(entityType, null), shapeSkills);
                }
                for (class_2960 entityTag : entityTags) {
                    skillMap.put(new Pair<>(null, entityTag), shapeSkills);
                }
            }
            return skillMap;
        })));
        return class_156.method_47526(codec.parse(JsonOps.INSTANCE, json), JsonParseException::new);
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    private static Codec<? extends ShapeSkill<?>> byNameCodec() {
        return class_2960.field_25139.flatXmap(
                resourceLocation -> (DataResult) Optional.ofNullable(SkillRegistry.getSkillCodec(resourceLocation))
                        .map(DataResult::success)
                        .orElseGet(() -> DataResult.error(() -> "Unknown shape skill: " + resourceLocation)),
                object -> Optional.ofNullable(SkillRegistry.getSkillId((ShapeSkill<?>) object))
                        .map(DataResult::success)
                        .orElseGet(() -> DataResult.error(() -> "Unknown shape skill:" + object))
        ).dispatchStable(object -> ((ShapeSkill<?>) object).codec(), Function.identity());
    }
}
