package tocraft.walkers.api.data.abilities;

import com.google.gson.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.api.data.variants.TypeProviderDataManager;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap.SimpleEntry;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class AbilityDataManager extends class_4309 {
    private static final String DEFAULT_PACKAGE = "tocraft.walkers.ability.impl";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, new class_2960.class_2961()).create();

    public AbilityDataManager() {
        super(GSON, Walkers.MODID + "/abilities");
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            Map.Entry<class_1299<?>, ShapeAbility<?>> convertedEntry = abilityEntryFromJson(mapEntry.getValue().getAsJsonObject());

            AbilityRegistry.registerByPredicate(entity -> entity.method_5864().equals(convertedEntry.getKey()), convertedEntry.getValue());

            Walkers.LOGGER.info("{}: {} registered for {}", getClass().getSimpleName(), convertedEntry.getKey(), convertedEntry.getValue());
        }
    }

    protected static Map.Entry<class_1299<?>, ShapeAbility<?>> abilityEntryFromJson(JsonObject json) {
        Codec<Map.Entry<class_1299<?>, ShapeAbility<?>>> codec = RecordCodecBuilder.create((instance) -> instance.group(
                class_2960.field_25139.fieldOf("entity_type").forGetter(o -> class_7923.field_41177.method_10221(o.getKey())),
                Codec.STRING.optionalFieldOf("required_mod", "").forGetter(o -> ""),
                Codec.STRING.fieldOf("ability_class").forGetter(o -> o.getValue().getClass().getName())
        ).apply(instance, instance.stable((entityType, requiredMod, shapeAbility) -> {
            if ((requiredMod.isBlank() || Platform.isModLoaded(requiredMod)) && class_7923.field_41177.method_10250(entityType)) {
                try {
                    String abilityClassName = shapeAbility.contains(".") ? shapeAbility : DEFAULT_PACKAGE + "." + shapeAbility;
                    return new SimpleEntry<class_1299<?>, ShapeAbility<?>>(class_7923.field_41177.method_10223(entityType), Class.forName(abilityClassName).asSubclass(ShapeAbility.class).getDeclaredConstructor().newInstance());
                } catch (ClassNotFoundException | InvocationTargetException | InstantiationException |
                         IllegalAccessException | NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            } else if (requiredMod.isBlank() || Platform.isModLoaded(requiredMod)) {
                Walkers.LOGGER.info("{}: EntityType not found for {}", TypeProviderDataManager.class.getSimpleName(), entityType);
            }
            return new SimpleEntry<>(null, null);
        })));
        return class_156.method_47526(codec.parse(JsonOps.INSTANCE, json), JsonParseException::new);
    }
}
