package tocraft.walkers.api;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;

public class PlayerShape {

    /**
     * Returns the shape associated with the {@link class_1657} this component is attached to.
     *
     * <p>Note that this method may return null, which represents "no shape."
     *
     * @return the current {@link class_1309} shape associated with this component's player owner, or null if they have no shape equipped
     */
    public static class_1309 getCurrentShape(class_1657 player) {
        return ((PlayerDataProvider) player).walkers$getCurrentShape();
    }

    /**
     * Sets the shape of the specified player.
     *
     * <p>Setting a shape refreshes the player's dimensions/hitbox, and toggles flight capabilities depending on the entity.
     * To clear this component's shape, pass null.
     *
     * @param entity {@link class_1309} new shape for this component, or null to clear
     */
    public static boolean updateShapes(class_3222 player, class_1309 entity) {
        return ((PlayerDataProvider) player).walkers$updateShapes(entity);
    }

    public static void sync(class_3222 player) {
        sync(player, player);
    }

    public static void sync(class_3222 changed, class_3222 packetTarget) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        class_2487 entityTag = new class_2487();

        // serialize current shape data to tag if it exists
        class_1309 shape = getCurrentShape(changed);
        if (shape != null) {
            shape.method_5647(entityTag);
        }

        // put entity type ID under the key "id", or "minecraft:empty" if no shape is equipped (or the shape entity type is invalid)
        packet.method_10797(changed.method_5667());
        packet.method_10814(shape == null ? "minecraft:empty" : class_7923.field_41177.method_10221(shape.method_5864()).toString());
        packet.method_10794(entityTag);
        NetworkManager.sendToPlayer(packetTarget, NetworkHandler.SHAPE_SYNC, packet);
    }
}
