package tocraft.walkers;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import dev.architectury.event.events.common.PlayerEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.VIPs;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.data.DataManager;
import tocraft.walkers.api.platform.WalkersConfig;
import tocraft.walkers.command.WalkersCommand;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.network.ServerNetworking;
import tocraft.walkers.registry.WalkersEventHandlers;
import tocraft.walkers.skills.ShapeSkill;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.AquaticSkill;
import tocraft.walkers.skills.impl.FlyingSkill;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class Walkers {

    public static final Logger LOGGER = LoggerFactory.getLogger(Walkers.class);
    public static final String MODID = "walkers";
    public static final WalkersConfig CONFIG = ConfigLoader.read(MODID, WalkersConfig.class);
    public static final List<UUID> devs = new ArrayList<>();

    static {
        devs.add(UUID.fromString("1f63e38e-4059-4a4f-b7c4-0fac4a48e744"));
        devs.add(UUID.fromString("494e1c8a-f733-43ed-8c1b-a2943fdc05f3"));
    }

    public void initialize() {
        MixinExtrasBootstrap.init();

        EntityBlacklist.init();
        AbilityRegistry.init();
        SkillRegistry.init();
        WalkersEventHandlers.initialize();
        WalkersCommand.register();
        ServerNetworking.initialize();
        registerJoinSyncPacket();
        WalkersTickHandlers.initialize();
        DataManager.initialize();
        Integrations.initialize();
    }

    public static void registerJoinSyncPacket() {
        VersionChecker.registerDefaultGitHubChecker(MODID, "ToCraft", "woodwalkers-mod", class_2561.method_43470("Woodwalkers"));

        PlayerEvent.PLAYER_JOIN.register(player -> {
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor) ((class_3218) player.method_37908())
                    .method_14178().field_17254).getEntityMap();
            trackers.forEach((entityid, tracking) -> {
                if (player.method_37908().method_8469(entityid) instanceof class_3222) {
                    PlayerShape.sync(((class_3222) player.method_51469().method_8469(entityid)), player);
                }
            });
        });
    }

    public static class_2960 id(String name) {
        return new class_2960(MODID, name);
    }

    public static boolean hasFlyingPermissions(class_3222 player) {
        if (player.method_7337())
            return true;

        class_1309 shape = PlayerShape.getCurrentShape(player);

        if (shape != null && Walkers.CONFIG.enableFlight
                && (SkillRegistry.has(shape, FlyingSkill.ID) || shape instanceof class_1307)) {
            List<String> requiredAdvancements = Walkers.CONFIG.advancementsRequiredForFlight;

            // requires at least 1 advancement, check if player has them
            if (!requiredAdvancements.isEmpty()) {

                boolean hasPermission = true;
                for (String requiredAdvancement : requiredAdvancements) {
                    class_161 advancement = player.field_13995.method_3851()
                            .method_12896(new class_2960(requiredAdvancement));
                    if (advancement != null) {
                        class_167 progress = player.method_14236().method_12882(advancement);

                        if (!progress.method_740()) {
                            hasPermission = false;
                        }
                    }
                }

                return hasPermission;
            }

            return true;
        }

        return false;
    }

    /**
     * @param entity the shape to be checked
     * @return 0 - water mob, 1 - land and water mob, 2 - land mob
     */
    public static int isAquatic(class_1309 entity) {
        if (entity != null) {
            for (ShapeSkill<class_1309> aquaticSkill : SkillRegistry.get(entity, AquaticSkill.ID)) {
                return ((AquaticSkill<class_1309>) aquaticSkill).isAquatic;
            }
            return entity.method_6046().equals(class_1310.field_6292) ? 0 : 2;
        } else {
            return 2;
        }
    }

    public static boolean isPlayerBlacklisted(UUID uuid) {
        return CONFIG.playerBlacklistIsWhitelist != CONFIG.playerUUIDBlacklist.contains(uuid);
    }

    public static boolean hasSpecialShape(UUID uuid) {
        return devs.contains(uuid) || VIPs.getCachedPatreons().contains(uuid);
    }
}
