/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network.impl;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;
import tocraft.walkers.registry.WalkersEntityTags;

public class UnlockPackets {
    private static final String UNLOCK_KEY = "UnlockedShape";

    public static void handleUnlockSyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        class_2487 nbt = packet.method_10798();
        if (nbt != null) {
            class_2487 idTag = nbt.method_10562(UNLOCK_KEY);
            ClientNetworking.runOrQueue(context, player -> {
                if (!idTag.method_33133()) {
                    ((PlayerDataProvider)player).walkers$set2ndShape(ShapeType.from(idTag));
                }
            });
        }
    }

    public static void registerShapeUnlockRequestPacketHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)NetworkHandler.UNLOCK_REQUEST, (buf, context) -> {
            if (Walkers.isPlayerBlacklisted(context.getPlayer().method_5667())) {
                return;
            }
            boolean validType = buf.readBoolean();
            if (validType) {
                class_2960 typeId = buf.method_10810();
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(typeId);
                int variant = buf.readInt();
                context.getPlayer().method_5682().execute(() -> {
                    boolean result;
                    @Nullable ShapeType<Z> type = ShapeType.from(entityType, variant);
                    if (type != null && !type.getEntityType().method_20210(WalkersEntityTags.BLACKLISTED) && (Walkers.CONFIG.unlockOverridesCurrentShape || ((PlayerDataProvider)context.getPlayer()).walkers$get2ndShape() == null) && (result = PlayerShapeChanger.change2ndShape((class_3222)context.getPlayer(), type))) {
                        PlayerShape.updateShapes((class_3222)context.getPlayer(), type.create(context.getPlayer().method_37908()));
                    }
                });
            } else {
                context.getPlayer().method_5682().execute(() -> PlayerShape.updateShapes((class_3222)context.getPlayer(), null));
            }
            context.getPlayer().method_18382();
        });
    }

    public static void sendSyncPacket(class_3222 player) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        class_2487 compound = new class_2487();
        class_2487 id = new class_2487();
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            id = ((PlayerDataProvider)player).walkers$get2ndShape().writeCompound();
        }
        compound.method_10566(UNLOCK_KEY, (class_2520)id);
        packet.method_10794(compound);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)NetworkHandler.UNLOCK_SYNC, (class_2540)packet);
    }

    public static void sendUnlockRequest(@Nullable ShapeType<? extends class_1309> type) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeBoolean(type != null);
        if (type != null) {
            packet.method_10812(class_7923.field_41177.method_10221(type.getEntityType()));
            packet.writeInt(type.getVariantData());
        }
        NetworkManager.sendToServer((class_2960)ClientNetworking.UNLOCK_REQUEST, (class_2540)packet);
    }
}

