/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1433;
import net.minecraft.class_1453;
import net.minecraft.class_1472;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.registry.WalkersEntityTags;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements NearbySongAccessor {
    @Unique
    private boolean walkers$nearbySongPlaying = false;

    @Shadow
    protected abstract int method_6064(int var1);

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=0))
    private boolean slowFall(class_1309 livingEntity, class_1291 effect) {
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin)) != null && !this.method_5715() && shape.method_5864().method_20210(WalkersEntityTags.SLOW_FALLING)) {
            return true;
        }
        return this.method_6059(class_1294.field_5906);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=1), ordinal=0)
    public float applyWaterCreatureSwimSpeedBoost(float j) {
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && Walkers.isAquatic(shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin))) {
            return 0.96f;
        }
        return j;
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin)) != null) {
            boolean takesFallDamage = shape.method_5747(fallDistance, damageMultiplier, damageSource);
            int damageAmount = ((LivingEntityAccessor)shape).callCalculateFallDamage(fallDistance, damageMultiplier);
            if (takesFallDamage && damageAmount > 0) {
                class_1309.class_6823 fallSounds = shape.method_39760();
                this.method_5783(damageAmount > 4 ? fallSounds.comp_302() : fallSounds.comp_301(), 1.0f, 1.0f);
                ((LivingEntityAccessor)shape).callPlayBlockFallSound();
                this.method_5643(this.method_48923().method_48827(), damageAmount);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hasEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnHasNightVision(class_1291 effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1309 shape;
            class_1657 player = (class_1657)livingEntityMixin;
            if (effect.equals(class_1294.field_5925) && (shape = PlayerShape.getCurrentShape(player)) instanceof class_1420) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"getEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnNightVisionInstance(class_1291 effect, CallbackInfoReturnable<class_1293> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1309 shape;
            class_1657 player = (class_1657)livingEntityMixin;
            if (effect.equals(class_1294.field_5925) && (shape = PlayerShape.getCurrentShape(player)) instanceof class_1420) {
                cir.setReturnValue((Object)new class_1293(class_1294.field_5925, 100000, 0, false, false));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEyeHeight"}, cancellable=true)
    public void getEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            try {
                class_1309 shape = PlayerShape.getCurrentShape(player);
                if (shape != null) {
                    cir.setReturnValue((Object)Float.valueOf(shape.method_18381(pose)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 entity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (entity = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)entity.method_29503());
        }
    }

    @Inject(method={"canBreatheUnderwater"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_canBreatheUnderwater(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 entity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (entity = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)(entity.method_6094() || entity instanceof class_1433 || entity.method_5864().method_20210(WalkersEntityTags.UNDROWNABLE) ? 1 : 0));
        }
    }

    @Inject(method={"setRecordPlayingNearby"}, at={@At(value="RETURN")})
    @Environment(value=EnvType.CLIENT)
    protected void shape_setRecordPlayingNearby(class_2338 songPosition, boolean playing, CallbackInfo ci) {
        if ((class_1309)this instanceof class_1657) {
            this.walkers$nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean shape_isNearbySongPlaying() {
        return this.walkers$nearbySongPlaying;
    }

    @Inject(method={"isInvertedHealAndHarm"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)shape.method_5999());
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_canStandOnFluid(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null && shape.method_5864().method_20210(WalkersEntityTags.LAVA_WALKING) && state.method_15767(class_3486.field_15518)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onClimbable"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) instanceof class_1628) {
            cir.setReturnValue((Object)(this.field_5976 || this.method_37908().method_8320(this.method_24515()).method_27852(class_2246.field_10343) ? 1 : 0));
        }
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void regenerateWoolFromFood(class_1937 level, class_1799 food, CallbackInfoReturnable<class_1799> cir) {
        class_1472 sheepShape;
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin)) instanceof class_1472 && (sheepShape = (class_1472)shape).method_6629()) {
            sheepShape.method_6635(false);
        }
    }

    @Inject(method={"eat"}, at={@At(value="RETURN")})
    private void dieFromCookies(class_1937 level, class_1799 food, CallbackInfoReturnable<class_1799> cir) {
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin)) instanceof class_1453) {
            player.method_6092(new class_1293(class_1294.field_5899, 900));
            if (player.method_7337() || !this.method_5655()) {
                this.method_5643(this.method_48923().method_48802(player), Float.MAX_VALUE);
            }
        }
    }
}

