/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.variant;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.registry.WalkersEntityTags;

public class ShapeType<T extends class_1309> {
    private static final List<class_1299<? extends class_1309>> LIVING_TYPE_CASH = new ArrayList<class_1299<? extends class_1309>>();
    private final class_1299<T> type;
    private final int variantData;

    public static <Z extends class_1309> int getDefaultVariantData(class_1299<Z> type) {
        TypeProvider<Z> provider = TypeProviderRegistry.getProvider(type);
        if (provider != null) {
            return provider.getFallbackData();
        }
        return -1;
    }

    public ShapeType(class_1299<T> type) {
        this.type = type;
        this.variantData = ShapeType.getDefaultVariantData(type);
    }

    public ShapeType(class_1299<T> type, int variantData) {
        this.type = type;
        this.variantData = variantData;
    }

    public ShapeType(T entity) {
        this.type = entity.method_5864();
        @Nullable TypeProvider<T> provider = TypeProviderRegistry.getProvider(this.type);
        this.variantData = provider != null ? provider.getVariantData(entity) : ShapeType.getDefaultVariantData(this.type);
    }

    @NotNull
    public static <Z extends class_1309> ShapeType<Z> from(class_1299<Z> entityType) {
        return new ShapeType<Z>(entityType, ShapeType.getDefaultVariantData(entityType));
    }

    @Nullable
    public static <Z extends class_1309> ShapeType<Z> from(Z entity) {
        if (entity == null) {
            return null;
        }
        class_1299 type = entity.method_5864();
        TypeProvider<Z> typeProvider = TypeProviderRegistry.getProvider(type);
        if (typeProvider != null) {
            return typeProvider.create(entity);
        }
        return ShapeType.from(type);
    }

    @Nullable
    public static ShapeType<?> from(class_2487 compound) {
        class_2960 id = new class_2960(compound.method_10558("EntityID"));
        if (!class_7923.field_41177.method_10250(id)) {
            return null;
        }
        return ShapeType.from((class_1299)class_7923.field_41177.method_10223(id), compound.method_10545("Variant") ? compound.method_10550("Variant") : -1);
    }

    @Nullable
    public static <Z extends class_1309> ShapeType<Z> from(class_1299<Z> entityType, int variant) {
        TypeProvider<Z> typeProvider = TypeProviderRegistry.getProvider(entityType);
        if (typeProvider != null && (variant < -1 || variant > typeProvider.getRange())) {
            return null;
        }
        return new ShapeType<Z>(entityType, variant);
    }

    @Deprecated
    public static List<ShapeType<?>> getAllTypes(class_1937 world) {
        return ShapeType.getAllTypes(world, true);
    }

    public static List<ShapeType<?>> getAllTypes(class_1937 world, boolean includeVariants) {
        if (LIVING_TYPE_CASH.isEmpty()) {
            for (class_1299 type : class_7923.field_41177) {
                try {
                    class_1297 instance = type.method_5883(world);
                    if (!(instance instanceof class_1309)) continue;
                    LIVING_TYPE_CASH.add((class_1299<? extends class_1309>)type);
                }
                catch (Exception e) {
                    Walkers.LOGGER.error(e.getLocalizedMessage());
                }
            }
        }
        ArrayList types = new ArrayList();
        for (class_1299<? extends class_1309> type : LIVING_TYPE_CASH) {
            if (type.method_20210(WalkersEntityTags.BLACKLISTED)) continue;
            TypeProvider<? extends class_1309> variant = TypeProviderRegistry.getProvider(type);
            if (variant != null && includeVariants) {
                for (int i = 0; i <= variant.getRange(); ++i) {
                    types.add(new ShapeType<class_1309>(type, i));
                }
                continue;
            }
            types.add(ShapeType.from(type));
        }
        return types;
    }

    public class_2487 writeCompound() {
        class_2487 compound = new class_2487();
        compound.method_10582("EntityID", class_7923.field_41177.method_10221(this.type).toString());
        compound.method_10569("Variant", this.variantData);
        return compound;
    }

    public class_1299<? extends class_1309> getEntityType() {
        return this.type;
    }

    public T create(class_1937 world) {
        TypeProvider<T> typeProvider = TypeProviderRegistry.getProvider(this.type);
        if (typeProvider != null) {
            return typeProvider.create(this.type, world, this.variantData);
        }
        return (T)((class_1309)this.type.method_5883(world));
    }

    public int getVariantData() {
        return this.variantData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeType that = (ShapeType)o;
        return this.variantData == that.variantData && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.variantData);
    }

    public static <L extends class_1309> class_2561 createTooltipText(L entity) {
        TypeProvider<L> provider = TypeProviderRegistry.getProvider(entity.method_5864());
        if (provider != null) {
            return provider.modifyText(entity, class_2561.method_43471((String)entity.method_5864().method_5882()));
        }
        return class_2561.method_43471((String)entity.method_5864().method_5882());
    }
}

