/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.abilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.api.data.variants.TypeProviderDataManager;

public class AbilityDataManager
extends class_4309 {
    private static final String DEFAULT_PACKAGE = "tocraft.walkers.ability.impl";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();

    public AbilityDataManager() {
        super(GSON, "walkers/abilities");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            Map.Entry<class_1299<?>, ShapeAbility<?>> convertedEntry = AbilityDataManager.abilityEntryFromJson(mapEntry.getValue().getAsJsonObject());
            AbilityRegistry.register(entity -> entity.method_5864().equals(convertedEntry.getKey()), convertedEntry.getValue());
            Walkers.LOGGER.info("{}: {} registered for {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), convertedEntry.getKey(), convertedEntry.getValue()});
        }
    }

    protected static Map.Entry<class_1299<?>, ShapeAbility<?>> abilityEntryFromJson(JsonObject json) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("entity_type").forGetter(o -> class_7923.field_41177.method_10221((Object)((class_1299)o.getKey()))), (App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(o -> ""), (App)Codec.STRING.fieldOf("ability_class").forGetter(o -> ((ShapeAbility)o.getValue()).getClass().getName())).apply((Applicative)instance, instance.stable((entityType, requiredMod, shapeAbility) -> {
            if ((requiredMod.isBlank() || Platform.isModLoaded((String)requiredMod)) && class_7923.field_41177.method_10250(entityType)) {
                try {
                    Object abilityClassName = shapeAbility.contains(".") ? shapeAbility : "tocraft.walkers.ability.impl." + shapeAbility;
                    return new AbstractMap.SimpleEntry<class_1299, ShapeAbility>((class_1299)class_7923.field_41177.method_10223(entityType), Class.forName((String)abilityClassName).asSubclass(ShapeAbility.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (requiredMod.isBlank() || Platform.isModLoaded((String)requiredMod)) {
                Walkers.LOGGER.info("{}: EntityType not found for {}", (Object)TypeProviderDataManager.class.getSimpleName(), entityType);
            }
            return new AbstractMap.SimpleEntry<Object, Object>(null, null);
        })));
        return (Map.Entry)class_156.method_47526((DataResult)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new);
    }
}

