/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1454;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1606;
import net.minecraft.class_1640;
import net.minecraft.class_3417;
import net.minecraft.class_4466;
import net.minecraft.class_5354;
import net.minecraft.class_6053;
import net.minecraft.class_7260;
import net.minecraft.class_7923;
import net.minecraft.class_8153;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.ability.impl.AngerAbility;
import tocraft.walkers.ability.impl.BlazeAbility;
import tocraft.walkers.ability.impl.ChickenAbility;
import tocraft.walkers.ability.impl.CowAbility;
import tocraft.walkers.ability.impl.CreeperAbility;
import tocraft.walkers.ability.impl.EnderDragonAbility;
import tocraft.walkers.ability.impl.EndermanAbility;
import tocraft.walkers.ability.impl.EndermiteAbility;
import tocraft.walkers.ability.impl.EvokerAbility;
import tocraft.walkers.ability.impl.GhastAbility;
import tocraft.walkers.ability.impl.HorseAbility;
import tocraft.walkers.ability.impl.LlamaAbility;
import tocraft.walkers.ability.impl.MushroomCowAbility;
import tocraft.walkers.ability.impl.PufferfishAbility;
import tocraft.walkers.ability.impl.SheepAbility;
import tocraft.walkers.ability.impl.ShulkerAbility;
import tocraft.walkers.ability.impl.SnifferAbility;
import tocraft.walkers.ability.impl.SnowGolemAbility;
import tocraft.walkers.ability.impl.WardenAbility;
import tocraft.walkers.ability.impl.WitchAbility;
import tocraft.walkers.ability.impl.WitherAbility;

public class AbilityRegistry {
    private static final Map<Predicate<class_1309>, ShapeAbility<?>> abilities = new LinkedHashMap();

    private AbilityRegistry() {
    }

    public static void init() {
        AbilityRegistry.register((class_1309 livingEntity) -> livingEntity instanceof class_5354, new AngerAbility());
        AbilityRegistry.register(class_1545.class, new BlazeAbility());
        AbilityRegistry.register(class_1548.class, new CreeperAbility());
        AbilityRegistry.register(class_1510.class, new EnderDragonAbility());
        AbilityRegistry.register(class_1560.class, new EndermanAbility());
        AbilityRegistry.register(class_1571.class, new GhastAbility());
        AbilityRegistry.register(class_1473.class, new SnowGolemAbility());
        AbilityRegistry.register(class_1528.class, new WitherAbility());
        AbilityRegistry.register(class_1430.class, new CowAbility());
        AbilityRegistry.register(class_6053.class, new CowAbility());
        AbilityRegistry.register(class_1559.class, new EndermiteAbility());
        AbilityRegistry.register(class_1501.class, new LlamaAbility());
        AbilityRegistry.register(class_1640.class, new WitchAbility());
        AbilityRegistry.register(class_1564.class, new EvokerAbility());
        AbilityRegistry.register(class_7260.class, new WardenAbility());
        AbilityRegistry.register(class_1493.class, new AngerAbility(class_3417.field_14922, class_3417.field_14575));
        AbilityRegistry.register(class_1472.class, new SheepAbility());
        AbilityRegistry.register(class_8153.class, new SnifferAbility());
        AbilityRegistry.register(class_1428.class, new ChickenAbility());
        AbilityRegistry.register(class_1438.class, new MushroomCowAbility());
        AbilityRegistry.register(class_1496.class, new HorseAbility());
        AbilityRegistry.register(class_4466.class, new AngerAbility(class_3417.field_20605, class_3417.field_20604));
        AbilityRegistry.register(class_1606.class, new ShulkerAbility());
        AbilityRegistry.register(class_1454.class, new PufferfishAbility());
    }

    public static <L extends class_1309> ShapeAbility<L> get(L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(class_7923.field_41177.method_10221((Object)shape.method_5864()).toString())) {
            return null;
        }
        ArrayList<ShapeAbility> shapeAbilities = new ArrayList<ShapeAbility>(abilities.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(shape)).map(Map.Entry::getValue).toList());
        return !shapeAbilities.isEmpty() ? (ShapeAbility)shapeAbilities.get(shapeAbilities.size() - 1) : null;
    }

    public static <A extends class_1309, T extends class_1299<A>> void register(T type, ShapeAbility<A> ability) {
        AbilityRegistry.register((class_1309 livingEntity) -> type.equals(livingEntity.method_5864()), ability);
    }

    public static <A extends class_1309> void register(Class<A> entityClass, ShapeAbility<A> ability) {
        AbilityRegistry.register(entityClass::isInstance, ability);
    }

    public static void register(Predicate<class_1309> entityPredicate, ShapeAbility<?> ability) {
        abilities.put(entityPredicate, ability);
    }

    public static <L extends class_1309> boolean has(L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(class_7923.field_41177.method_10221((Object)shape.method_5864()).toString())) {
            return false;
        }
        return abilities.keySet().stream().anyMatch(predicate -> predicate.test(shape));
    }
}

