/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers;

import dev.architectury.event.events.common.PlayerEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.VIPs;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.api.data.DataManager;
import tocraft.walkers.api.platform.WalkersConfig;
import tocraft.walkers.command.WalkersCommand;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.network.ServerNetworking;
import tocraft.walkers.registry.WalkersEntityTags;
import tocraft.walkers.registry.WalkersEventHandlers;

public class Walkers {
    public static final Logger LOGGER = LoggerFactory.getLogger(Walkers.class);
    public static final String MODID = "walkers";
    private static final String MAVEN_URL = "https://maven.tocraft.dev/public/dev/tocraft/walkers/maven-metadata.xml";
    public static final WalkersConfig CONFIG = (WalkersConfig)ConfigLoader.read((String)"walkers", WalkersConfig.class);
    public static final List<UUID> devs = new ArrayList<UUID>();

    public void initialize() {
        AbilityRegistry.init();
        WalkersEventHandlers.initialize();
        WalkersCommand.register();
        ServerNetworking.initialize();
        Walkers.registerJoinSyncPacket();
        WalkersTickHandlers.initialize();
        DataManager.initialize();
        Integrations.initialize();
    }

    public static void registerJoinSyncPacket() {
        try {
            VersionChecker.registerMavenChecker((String)MODID, (URL)new URL(MAVEN_URL), (class_2561)class_2561.method_43471((String)"key.categories.walkers"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        PlayerEvent.PLAYER_JOIN.register(player -> {
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((class_3218)player.method_37908()).method_14178().field_17254).getEntityMap();
            trackers.forEach((entityid, tracking) -> {
                if (player.method_37908().method_8469(entityid.intValue()) instanceof class_3222) {
                    PlayerShape.sync((class_3222)player.method_51469().method_8469(entityid.intValue()), player);
                }
            });
        });
    }

    public static class_2960 id(String name) {
        return new class_2960(MODID, name);
    }

    public static boolean hasFlyingPermissions(class_3222 player) {
        if (player.method_7337()) {
            return true;
        }
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)player);
        if (shape != null && Walkers.CONFIG.enableFlight && (shape.method_5864().method_20210(WalkersEntityTags.FLYING) || shape instanceof class_1307)) {
            List<String> requiredAdvancements = Walkers.CONFIG.advancementsRequiredForFlight;
            if (!requiredAdvancements.isEmpty()) {
                boolean hasPermission = true;
                for (String requiredAdvancement : requiredAdvancements) {
                    class_167 progress;
                    class_161 advancement = player.field_13995.method_3851().method_12896(new class_2960(requiredAdvancement));
                    if (advancement == null || (progress = player.method_14236().method_12882(advancement)).method_740()) continue;
                    hasPermission = false;
                }
                return hasPermission;
            }
            return true;
        }
        return false;
    }

    public static boolean isAquatic(class_1309 entity) {
        return entity != null && entity.method_6046().equals(class_1310.field_6292);
    }

    public static boolean isPlayerBlacklisted(UUID uuid) {
        return Walkers.CONFIG.playerBlacklistIsWhitelist != Walkers.CONFIG.playerUUIDBlacklist.contains(uuid);
    }

    public static boolean hasSpecialShape(UUID uuid) {
        return devs.contains(uuid) || VIPs.getCachedPatreons().contains(uuid);
    }

    static {
        devs.add(UUID.fromString("1f63e38e-4059-4a4f-b7c4-0fac4a48e744"));
        devs.add(UUID.fromString("494e1c8a-f733-43ed-8c1b-a2943fdc05f3"));
    }
}

