package tocraft.walkers.mixin.client.player;

import com.mojang.authlib.GameProfile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.client.CMinecraft;
import tocraft.walkers.impl.PlayerDataProvider;

import java.util.Optional;
import java.util.UUID;

@Environment(EnvType.CLIENT)
//#if MC>1182
@Mixin(class_742.class)
public abstract class AbstractClientPlayerMixin extends class_1657 {

    public AbstractClientPlayerMixin(class_1937 level, class_2338 pos, float yRot, GameProfile gameProfile) {
       super(level, pos, yRot, gameProfile);
   }
//#else
//$$ @Mixin(Player.class)
//$$ public abstract class AbstractClientPlayerMixin extends LivingEntity {
//$$     protected AbstractClientPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
//$$         super(entityType, level);
//$$     }
//$$
//#endif
    @SuppressWarnings("ConstantConditions")
    @Inject(method = "tick", at = @At("HEAD"))
    private void clientTick(CallbackInfo info) {
        Optional<UUID> vehiclePlayerId = ((PlayerDataProvider) this).walkers$getVehiclePlayerUUID();
        if (vehiclePlayerId.isPresent() && CMinecraft.isLocalPlayer(vehiclePlayerId.get())) {
            class_243 vehiclePos = class_310.method_1551().field_1724.method_19538();
            this.method_24203(vehiclePos.field_1352, vehiclePos.field_1351 + 1, vehiclePos.field_1350);
        }
    }
}
