package tocraft.walkers.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_1646.class)
public abstract class VillagerEntityMixin {

    @Shadow
    protected abstract void stopTrading();

    @Inject(method = "mobInteract", at = @At("HEAD"), cancellable = true)
    private void onInteract(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1309 shape = PlayerShape.getCurrentShape(player);

        if (shape != null && shape.method_5999()) {
            this.stopTrading();
            cir.setReturnValue(class_1269.field_5812);
        }
    }
}
