package tocraft.walkers.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1361;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_1361.class)
public class LookAtPlayerGoalMixin {
    @Shadow
    @Nullable
    protected class_1297 lookAt;
    @Shadow
    @Final
    protected class_1308 mob;

    @Inject(method = "canUse", at = @At("RETURN"), cancellable = true)
    private void onCanUse(CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValue()) {
            // prevent mobs from looking at the player
            cir.setReturnValue(!(this.lookAt instanceof class_1657 player && PlayerShape.getCurrentShape(player) != null && PlayerShape.getCurrentShape(player).method_5864() == this.mob.method_5864()));
        }
    }
}
