package tocraft.walkers.integrations.impl;

import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.integrations.AbstractIntegration;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.FearedTrait;
import tocraft.walkers.traits.impl.PreyTrait;

import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_6862;

@SuppressWarnings("unchecked")
public class AlexMobsIntegration extends AbstractIntegration {
    public static final String MODID = "alexsmobs";

    @Override
    public void registerTraits() {
        // PreyTrait
        registerAlexMobsTargetTagTrait("anaconda", 1, 200);
        registerAlexMobsTargetTagTrait("bald_eagle", 4, 55);
        registerAlexMobsTargetTagTrait("cachalot_whale", 2, 30);
        registerAlexMobsTargetTagTrait("crimson-mosquito",2, 50);
        registerAlexMobsTargetTagTrait("crocodile", 5, 180);
        TraitRegistry.registerByType(getType("fly"), new PreyTrait<>(List.of(), List.of(), List.of(), List.of(getTag("fly_hurt_targets")), 3, 5));
        registerAlexMobsTargetTagTrait("froststalker", 3, 80);
        registerAlexMobsTargetTagTrait("giant-squid", 3, 70);
        registerAlexMobsTargetTagTrait("komodo-dragon", 8, 180);
        registerAlexMobsTargetTagTrait("mantis_shrimp", 3, 120);
        registerAlexMobsTargetTagTrait("orca",3 , 200);
        registerAlexMobsTargetTagTrait("snow_leopard", 2, 10);
        registerAlexMobsTargetTagTrait("sunbird_scorch", 3, 5);
        registerAlexMobsTargetTagTrait("tiger",4 ,220);
        registerAlexMobsTargetTagTrait("warped_toad",4, 50);
        TraitRegistry.registerByPredicate(entity -> (entity instanceof class_1569 && !(entity instanceof class_1548) && !(entity.method_5864().method_5891().name().contains("water") && entity.method_5816()) && !entity.method_5864().method_20210(getTag("bunfungus_ignores"))), new PreyTrait<>(List.of(), List.of(getType("bunfungus")), List.of(), List.of(), 3, 5));
        // FearedTrait
        registerAlexMobsFearTagTrait("mimic_octopus");
        registerAlexMobsFearTagTrait("skunk");
    }

    private void registerAlexMobsTargetTagTrait(String entityId, int priority, int randInt) {
        TraitRegistry.registerByTag(getTag(entityId + "_targets"), new PreyTrait<>(List.of(), List.of(getType(entityId)), List.of(), List.of(), priority, randInt));
    }

    private void registerAlexMobsFearTagTrait(String entityId) {
        TraitRegistry.registerByTag((getTag(entityId + "_fears")), (FearedTrait<class_1308>) FearedTrait.ofFearfulType(getType(entityId)));
    }

    private static class_1299<class_1308> getType(String entityId) {
        return (class_1299<class_1308>) Walkers.getEntityTypeRegistry().method_10223(Identifier.parse(MODID, entityId));
    }

    private static class_6862<class_1299<?>> getTag(String tagId) {
        return class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Identifier.parse(MODID, tagId));
    }
}
