package tocraft.walkers.api.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1453;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.model.impl.AbstractHorseEntityUpdater;
import tocraft.walkers.api.model.impl.ShulkerEntityUpdater;
import tocraft.walkers.api.model.impl.SquidEntityUpdater;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.mixin.accessor.CreeperEntityAccessor;
import tocraft.walkers.mixin.accessor.ParrotEntityAccessor;

import java.util.LinkedHashMap;
import java.util.Map;

//#if MC>=1203
import tocraft.walkers.mixin.accessor.BatAccessor;
//#endif
//#if MC>1182
import tocraft.walkers.mixin.accessor.AllayAccessor;
//#endif

/**
 * Registry class for {@link EntityUpdater} instances.
 *
 * <p>
 * {@link EntityUpdater}s are used to apply changes to shape entity instances on
 * the client using information from the player. As an example, an
 * {@link EntityUpdater} can be used to tell a shape bat to "stop roosting,"
 * which triggers the flight animation. {@link EntityUpdater}s are called once
 * every render tick
 * {@link net.minecraft.class_897#method_3936(class_1297, float, float, class_4587, class_4597, int)}.
 */
@Environment(EnvType.CLIENT)
public class EntityUpdaters {

    private static final Map<class_1299<? extends class_1309>, EntityUpdater<? extends class_1309>> map = new LinkedHashMap<>();

    /**
     * Returns a {@link EntityUpdater} if one has been registered for the given
     * {@link class_1299}, or null.
     *
     * @param entityType entity type key to retrieve a value registered in
     *                   {@link EntityUpdaters#register(class_1299, EntityUpdater)}
     * @param <T>        passed in {@link class_1299} generic
     * @return registered {@link EntityUpdater} instance for the given
     * {@link class_1299}, or null if one does not exist
     */
    @SuppressWarnings("unchecked")
    public static <T extends class_1309> EntityUpdater<T> getUpdater(class_1299<T> entityType) {
        return (EntityUpdater<T>) map.getOrDefault(entityType, null);
    }

    /**
     * Registers an {@link EntityUpdater} for the given {@link class_1299}.
     *
     * <p>
     * Note that a given {@link class_1299} can only have 1 {@link EntityUpdater}
     * associated with it.
     *
     * @param type          entity type key associated with the given
     *                      {@link EntityUpdater}
     * @param entityUpdater {@link EntityUpdater} associated with the given
     *                      {@link class_1299}
     * @param <T>           passed in {@link class_1299} generic
     */
    public static <T extends class_1309> void register(class_1299<T> type, EntityUpdater<T> entityUpdater) {
        map.put(type, entityUpdater);
    }

    public static void init() {
        EntityUpdaters.register(class_1299.field_6139, new AbstractHorseEntityUpdater<>());
        EntityUpdaters.register(class_1299.field_6067, new AbstractHorseEntityUpdater<>());
        EntityUpdaters.register(class_1299.field_6057, new AbstractHorseEntityUpdater<>());

        //#if MC>1182
        EntityUpdaters.register(class_1299.field_38384, (player, allay) -> {
            ((AllayAccessor) allay).setHoldingItemAnimationTicks0(((AllayAccessor) allay).getHoldingItemAnimationTicks());
            if (allay.method_43396()) {
                ((AllayAccessor) allay).setHoldingItemAnimationTicks(class_3532.method_15363(((AllayAccessor) allay).getHoldingItemAnimationTicks() + 1.0F, 0.0F, 5.0F));
            } else {
                ((AllayAccessor) allay).setHoldingItemAnimationTicks(class_3532.method_15363(((AllayAccessor) allay).getHoldingItemAnimationTicks() - 1.0F, 0.0F, 5.0F));
            }
        });
        //#endif

        // register specific entity animation handling
        EntityUpdaters.register(class_1299.field_6108, (player, bat) -> {
            bat.method_6449(!CEntity.level(player).method_8320(player.method_24515().method_10084()).method_26215());
            //#if MC>=1203
            ((BatAccessor) bat).callSetupAnimationStates();
            //#endif
        });

        EntityUpdaters.register(class_1299.field_6104, (player, parrot) -> {
            parrot.method_6006(player.method_24515(), ((NearbySongAccessor) player).shape_isNearbySongPlaying());
            ((ParrotEntityAccessor) parrot).callCalculateFlapping();
            // imitate sounds
            if (player.method_6051().method_43048(400) == 0) {
                class_1453.method_6587(CEntity.level(player), player);
            }
        });

        EntityUpdaters.register(class_1299.field_6116, (player, dragon) -> {
            dragon.field_7030 += 0.01F;
            dragon.field_7019 = dragon.field_7030;

            // setting yaw without +180 making tail faces front, for some reason
            if (dragon.field_7010 < 0) {
                for (int l = 0; l < dragon.field_7026.length; ++l) {
                    dragon.field_7026[l][0] = (double) player.method_36454() + 180;
                    dragon.field_7026[l][1] = player.method_23318();
                }
            }

            if (++(dragon).field_7010 == (dragon).field_7026.length) {
                (dragon).field_7010 = 0;
            }

            dragon.field_7026[dragon.field_7010][0] = (double) player.method_36454() + 180;
            dragon.field_7026[dragon.field_7010][1] = player.method_23318();
        });

        EntityUpdaters.register(class_1299.field_6091, (player, enderman) -> {
            class_1799 heldStack = player.method_6047();

            if (heldStack.method_7909() instanceof class_1747) {
                enderman.method_7032(((class_1747) heldStack.method_7909()).method_7711().method_9564());
            }
        });

        // To prevent Creeper shapes from flickering white, we reset currentFuseTime to
        // 0.
        // Creepers normally tick their fuse timer in tick(), but:
        // 1. shapes do not tick
        // 2. The Creeper ability is instant, so we do not need to re-implement ticking
        EntityUpdaters.register(class_1299.field_6046, (player, creeper) -> ((CreeperEntityAccessor) creeper).setSwell(0));

        EntityUpdaters.register(class_1299.field_6114, new SquidEntityUpdater<>());
        EntityUpdaters.register(class_1299.field_28402, new SquidEntityUpdater<>());

        EntityUpdaters.register(class_1299.field_6109, new ShulkerEntityUpdater());

        EntityUpdaters.register(class_1299.field_6132, (player, chicken) -> {
            chicken.field_6736 = chicken.field_6741;
            chicken.field_6738 = chicken.field_6743;
            chicken.field_6743 += (CEntity.isOnGround(player) ? -1.0F : 4.0F) * 0.3F;
            chicken.field_6743 = class_3532.method_15363(chicken.field_6743, 0.0F, 1.0F);
            if (!CEntity.isOnGround(player) && chicken.field_6737 < 1.0F) {
                chicken.field_6737 = 1.0F;
            }
            chicken.field_6737 *= 0.9F;
            chicken.field_6741 += chicken.field_6737 * 2.0F;
        });

        // make strider shaking and purple when out of lava
        EntityUpdaters.register(class_1299.field_23214, (player, strider) -> {
            class_2680 blockState = CEntity.level(player).method_8320(player.method_24515());
            boolean bl = blockState.method_26164(class_3481.field_23209) || player.method_5861(class_3486.field_15518) > 0.0;
            strider.method_26349(!bl);
        });

        EntityUpdaters.register(class_1299.field_16281, (player, cat) -> cat.method_6179(false));
    }
}
