package tocraft.walkers.api.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

/**
 * Implementers should use the provided {@link class_1657} instance to update the provided {@link Entity}'s properties.
 *
 * <p>{@link EntityUpdater} instances can be registered and retrieved through {@link EntityUpdaters}.
 *
 * @param <Entity>
 */
@Environment(EnvType.CLIENT)
@FunctionalInterface
public interface EntityUpdater<Entity extends class_1309> {

    /**
     * Updates the given {@link Entity} using properties from the given {@link class_1657}.
     *
     * <p>Called once every render update on the client.
     *
     * @param from {@link class_1657} to copy properties from
     * @param to   {@link Entity} to copy properties to
     */
    void update(class_1657 from, Entity to);
}
