package tocraft.walkers.ability.impl.specific;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class GrassEaterAbility<T extends class_1309> extends ShapeAbility<T> {
    public static final class_2960 ID = Walkers.id("eat_grass");
    public static final MapCodec<GrassEaterAbility<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.stable(new GrassEaterAbility<>()));

    public final Map<UUID, Integer> eatTick = new HashMap<>();

    @Override
    public void onUse(class_1657 player, T shape, class_1937 world) {
        eatGrass(player);
    }

    public void eatGrass(class_1657 player) {
        eatTick.put(player.method_5667(), class_3532.method_38788(40, 2));
    }

    @Override
    public class_1792 getIcon() {
        return (class_1792) CRegistries.getRegistry(Identifier.parse("item")).method_10223(Identifier.parse("short_grass"));
    }
}
