/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.integrations;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.integrations.AbstractIntegration;
import tocraft.walkers.integrations.impl.AlexMobsIntegration;
import tocraft.walkers.integrations.impl.GuardVillagersIntegration;
import tocraft.walkers.integrations.impl.MobBattleModIntegration;
import tocraft.walkers.integrations.impl.MoreMobVariantsIntegration;
import tocraft.walkers.integrations.impl.MutantMonstersIntegration;
import tocraft.walkers.integrations.impl.PlayerAbilityLibIntegration;

public class Integrations {
    private static final Map<String, AbstractIntegration> INTEGRATIONS = new HashMap<String, AbstractIntegration>();

    public static void initIntegrations() {
        Integrations.register("mobbattle", MobBattleModIntegration::new);
        Integrations.register("guardvillagers", GuardVillagersIntegration::new);
        Integrations.register("moremobvariants", MoreMobVariantsIntegration::new);
        Integrations.register("mutantmonsters", MutantMonstersIntegration::new);
        Integrations.register("alexsmobs", AlexMobsIntegration::new);
        Integrations.register("playerabilitylib", PlayerAbilityLibIntegration::new);
    }

    public static void registerAbilities() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerAbilities();
        }
    }

    public static void registerTraits() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerTraits();
        }
    }

    public static void registerTypeProvider() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerTypeProvider();
        }
    }

    public static void registerEntityBlacklist() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerEntityBlacklist();
        }
    }

    public static void initialize() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.initialize();
        }
    }

    public static boolean mightAttackInnocent(class_1297 entity1, class_1297 entity2) {
        boolean bool = true;
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            bool = bool && loadedIntegration.mightAttackInnocent(entity1, entity2);
        }
        return bool;
    }

    public static void register(String modid, AbstractIntegration integration) {
        if (PlatformData.isModLoaded((String)modid)) {
            INTEGRATIONS.put(modid, integration);
        }
    }

    public static void register(String modid, Supplier<AbstractIntegration> integration) {
        if (PlatformData.isModLoaded((String)modid)) {
            INTEGRATIONS.put(modid, integration.get());
        }
    }
}

