/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.variant;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.impl.variant.AxolotlTypeProvider;
import tocraft.walkers.impl.variant.CatTypeProvider;
import tocraft.walkers.impl.variant.CreeperTypeProvider;
import tocraft.walkers.impl.variant.FoxTypeProvider;
import tocraft.walkers.impl.variant.FrogTypeProvider;
import tocraft.walkers.impl.variant.HorseTypeProvider;
import tocraft.walkers.impl.variant.LlamaTypeProvider;
import tocraft.walkers.impl.variant.MagmaCubeTypeProvider;
import tocraft.walkers.impl.variant.MushroomCowTypeProvider;
import tocraft.walkers.impl.variant.PandaTypeProvider;
import tocraft.walkers.impl.variant.ParrotTypeProvider;
import tocraft.walkers.impl.variant.RabbitTypeProvider;
import tocraft.walkers.impl.variant.SheepTypeProvider;
import tocraft.walkers.impl.variant.ShulkerTypeProvider;
import tocraft.walkers.impl.variant.SlimeTypeProvider;
import tocraft.walkers.impl.variant.TropicalFishTypeProvider;
import tocraft.walkers.impl.variant.VillagerTypeProvider;
import tocraft.walkers.impl.variant.ZombieVillagerTypeProvider;
import tocraft.walkers.integrations.Integrations;

public class TypeProviderRegistry {
    private static final Map<class_1299<? extends class_1309>, TypeProvider<? extends class_1309>> VARIANT_BY_TYPE = new LinkedHashMap<class_1299<? extends class_1309>, TypeProvider<? extends class_1309>>();

    public static void registerDefault() {
        TypeProviderRegistry.register(class_1299.field_6046, new CreeperTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6115, new SheepTypeProvider());
        TypeProviderRegistry.register(class_1299.field_28315, new AxolotlTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6104, new ParrotTypeProvider());
        TypeProviderRegistry.register(class_1299.field_17943, new FoxTypeProvider());
        TypeProviderRegistry.register(class_1299.field_16281, new CatTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6069, new SlimeTypeProvider());
        TypeProviderRegistry.register(class_1299.field_37419, new FrogTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6139, new HorseTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6074, new LlamaTypeProvider());
        TypeProviderRegistry.register(class_1299.field_17714, new LlamaTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6102, new MagmaCubeTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6143, new MushroomCowTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6146, new PandaTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6140, new RabbitTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6077, new VillagerTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6054, new ZombieVillagerTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6111, new TropicalFishTypeProvider());
        TypeProviderRegistry.register(class_1299.field_6109, new ShulkerTypeProvider());
        Integrations.registerTypeProvider();
    }

    public static <T extends class_1309> void register(class_1299<T> type, TypeProvider<T> provider) {
        VARIANT_BY_TYPE.put(type, provider);
    }

    public static <T extends class_1309> boolean hasProvider(class_1299<T> type) {
        return VARIANT_BY_TYPE.containsKey(type);
    }

    @Nullable
    public static <T extends class_1309> TypeProvider<T> getProvider(class_1299<T> type) {
        return VARIANT_BY_TYPE.get(type);
    }

    public static List<Pair<class_1299<? extends class_1309>, TypeProvider<?>>> getAll() {
        ArrayList typeList = new ArrayList();
        VARIANT_BY_TYPE.forEach((entityType, typeProvider) -> typeList.add(new Pair(entityType, typeProvider)));
        return typeList;
    }

    public static void clearAll() {
        VARIANT_BY_TYPE.clear();
    }
}

