package tocraft.walkers.traits.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

@SuppressWarnings("unused")
public class PreyTrait<E extends class_1309> extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("prey");
    public static final MapCodec<PreyTrait<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            Codec.list(class_2960.field_25139).optionalFieldOf("hunter", new ArrayList<>()).forGetter(o -> o.hunterTypes.stream().map(Walkers.getEntityTypeRegistry()::method_10221).toList()),
            Codec.list(class_2960.field_25139).optionalFieldOf("hunter_tags", new ArrayList<>()).forGetter(o -> o.hunterTags.stream().map(class_6862::comp_327).toList())
    ).apply(instance, instance.stable((hunterLocations, hunterTagLocations) -> {
                List<class_1299<?>> hunterTypes = new ArrayList<>();
                List<class_6862<class_1299<?>>> hunterTags = new ArrayList<>();
                for (class_2960 resourceLocation : hunterLocations) {
                    if (Walkers.getEntityTypeRegistry().method_10250(resourceLocation)) {
                        hunterTypes.add(Walkers.getEntityTypeRegistry().method_10223(resourceLocation));
                    }
                }
                for (class_2960 hunterTagLocation : hunterTagLocations) {
                    hunterTags.add(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), hunterTagLocation));
                }
                return new PreyTrait<>(new ArrayList<>(), hunterTypes, new ArrayList<>(), hunterTags);
            }
    )));

    private final List<Predicate<class_1309>> hunterPredicates;
    private final List<class_1299<?>> hunterTypes;
    private final List<Class<? extends class_1309>> hunterClasses;
    private final List<class_6862<class_1299<?>>> hunterTags;
    private final int priority;
    private final int randInt;

    public static PreyTrait<?> ofHunterType(class_1299<?>... hunter) {
        return new PreyTrait<>(new ArrayList<>(), List.of(hunter), new ArrayList<>(), new ArrayList<>());
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterTag(class_6862<class_1299<?>>... hunter) {
        return new PreyTrait<>(new ArrayList<>(), new ArrayList<>(), new ArrayList<>(), List.of(hunter));
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterClass(Class<? extends class_1309>... hunter) {
        return new PreyTrait<>(new ArrayList<>(), new ArrayList<>(), List.of(hunter), new ArrayList<>());
    }


    public PreyTrait(@NotNull List<Predicate<class_1309>> hunterPredicates) {
        this(hunterPredicates, new ArrayList<>(), new ArrayList<>(), new ArrayList<>());
    }

    public PreyTrait(@NotNull List<Predicate<class_1309>> hunterPredicates, @NotNull List<class_1299<?>> hunterTypes, @NotNull List<Class<? extends class_1309>> hunterClasses, @NotNull List<class_6862<class_1299<?>>> hunterTags) {
        this(hunterPredicates, hunterTypes, hunterClasses, hunterTags, 7, 10);
    }

    public PreyTrait(@NotNull List<Predicate<class_1309>> hunterPredicates, @NotNull List<class_1299<?>> hunterTypes, @NotNull List<Class<? extends class_1309>> hunterClasses, @NotNull List<class_6862<class_1299<?>>> hunterTags, int priority, int randInt) {
        this.hunterPredicates = hunterPredicates;
        this.hunterTypes = hunterTypes;
        this.hunterClasses = hunterClasses;
        this.hunterTags = hunterTags;
        this.priority = priority;
        this.randInt = randInt;
    }

    public boolean isHunter(class_1309 entity) {
        if (hunterTypes.contains(entity.method_5864())) return true;
        for (Class<? extends class_1309> hunterClass : hunterClasses) {
            if (hunterClass.isInstance(entity)) return true;
        }
        for (class_6862<class_1299<?>> hunterTag : hunterTags) {
            if (entity.method_5864().method_20210(hunterTag)) return true;
        }
        for (Predicate<class_1309> hunterPredicate : hunterPredicates) {
            if (hunterPredicate.test(entity)) return true;
        }
        return false;
    }

    public int getPriority() {
        return priority;
    }

    public int getRandInt() {
        return randInt;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}
