package tocraft.walkers.network.impl;

import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class SwapPackets {

    @SuppressWarnings({"unchecked", "ConstantConditions"})
    public static void registerWalkersRequestPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.C2S, NetworkHandler.SHAPE_REQUEST,
                (context, packet) -> context.getPlayer().method_5682().execute(() -> {
                    // check if player is blacklisted
                    if (Walkers.isPlayerBlacklisted(context.getPlayer().method_5667()) && Walkers.CONFIG.blacklistPreventsMorphing) {
                        context.getPlayer().method_7353(TComponent.translatable("walkers.player_blacklisted"), true);
                        return;
                    }

                    if (!ApiLevel.getCurrentLevel().canMorph) {
                        return;
                    }

                    // make the default ShapeType null, doing it this way, it's ensured that invalid 2ndShapes won't cause crashes.
                    @Nullable
                    ShapeType<class_1309> type = null;
                    // Get 2ndShape of Player, if the Player is in first shape rn.
                    if (PlayerShape.getCurrentShape(context.getPlayer()) == null) {
                        type = (@Nullable ShapeType<class_1309>) ((PlayerDataProvider) context.getPlayer()).walkers$get2ndShape();
                    }

                    // Swap to other Shape
                    if (type != null) {
                        // update Player
                        PlayerShape.updateShapes((class_3222) context.getPlayer(),
                                type.create(CEntity.level(context.getPlayer()), context.getPlayer()));
                    } else {
                        // Swap back to player if server allows it
                        PlayerShape.updateShapes((class_3222) context.getPlayer(), null);
                    }

                    // Refresh player dimensions
                    context.getPlayer().method_18382();
                }));
    }

    public static void sendSwapRequest() {
        if (!ApiLevel.getCurrentLevel().canMorph) {
            return;
        }

        ModernNetworking.sendToServer(ClientNetworking.SHAPE_REQUEST, new class_2487());
    }
}
