package tocraft.walkers.mixin.player;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_1657.class)
public abstract class PlayerEntityAttackMixin extends class_1309 {

    private PlayerEntityAttackMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "attack", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;skipAttackInteraction(Lnet/minecraft/world/entity/Entity;)Z"), cancellable = true)
    private void shapeAttack(class_1297 target, CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape != null) {
            if (method_6047().method_7960()) {
                try {
                    shape.method_6121(target);
                    ci.cancel();
                } catch (Exception ignored) {
                    // FALL BACK TO DEFAULT BEHAVIOR.
                    // Some mobs do not override, so it defaults to attack damage attribute, but the identity does not have any
                }
            }
        }
    }
}
