package tocraft.walkers.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_4838;
import net.minecraft.class_5418;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_4838.class)
public class PiglinBrainMixin {

    @Inject(method = "isWearingGold", at = @At("RETURN"), cancellable = true)
    private static void shapeIsWearingGold(class_1309 livingEntity, CallbackInfoReturnable<Boolean> cir) {
        boolean wearingGold = cir.getReturnValue();

        if (!wearingGold && livingEntity instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                // Piglins should not attack Piglins or Piglin Brutes, unless they have
                // hostility
                if (shape instanceof class_5418) {
                    cir.setReturnValue(true);
                }

                // Player has a shape but is not a piglin, check config for what to do
                else {
                    if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && shape instanceof class_1569) {

                        // Check hostility for aggro on non-piglin hostiles
                        if (!PlayerHostility.hasHostility(player)) {
                            cir.setReturnValue(false);
                        }
                    }
                }
            }
        }
    }
}
