package tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.api.variant.TypeProvider;

import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1451;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class CatTypeProvider extends TypeProvider<class_1451> {

    private static final Map<Integer, String> PREFIX_BY_ID = ImmutableMap
            .<Integer, String>builder()
            .put(0, "Tabby")
            .put(1, "Black")
            .put(2, "Red")
            .put(3, "Siamese")
            .put(4, "British Shorthair")
            .put(5, "Calico")
            .put(6, "Persian")
            .put(7, "Ragdoll")
            .put(8, "White")
            .put(9, "Jellie")
            .put(10, "Black")
            .build();

    @Override
    public int getVariantData(class_1451 entity) {
        //#if MC>=1205
        return class_7923.field_41163.method_10206(entity.method_47843().value());
        //#elseif MC>1182
        //$$ return BuiltInRegistries.CAT_VARIANT.getId(entity.getVariant());
        //#else
        //$$ return entity.getCatType();
        //#endif
    }

    @Override
    public class_1451 create(class_1299<class_1451> type, class_1937 world, int data) {
        class_1451 cat = new class_1451(type, world);
        //#if MC>=1205
        cat.method_47842(class_7923.field_41163.method_40265(data).orElseThrow());
        //#elseif MC>1182
        //$$ cat.setVariant(BuiltInRegistries.CAT_VARIANT.byId(data));
        //#else
        //$$ cat.setCatType(data);
        //#endif
        return cat;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        //#if MC>1182
        return class_7923.field_41163.method_10204() - 1;
        //#else
        //$$ return 10;
        //#endif
    }

    @Override
    public class_2561 modifyText(class_1451 cat, class_5250 text) {
        int variant = getVariantData(cat);
        return TComponent.literal(PREFIX_BY_ID.containsKey(variant) ? PREFIX_BY_ID.get(variant) + " " : "").method_10852(text);
    }
}
