package tocraft.walkers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import static tocraft.craftedcore.patched.CCommandSourceStack.sendSuccess;

public class WalkersCommand {
    //#if MC>1182
    public static void initialize() {
        CommandEvents.REGISTRATION.register((dispatcher, ctx, selection) -> register(dispatcher, ctx));
    }
    private static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx) {
    //#else
    //$$ public static void initialize() {
    //$$     CommandEvents.REGISTRATION.register((dispatcher, ctx) -> register(dispatcher));
    //$$ }
    //$$
    //$$ private static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
    //$$     Object ctx = null;
    //#endif
        LiteralCommandNode<class_2168> rootNode = class_2170.method_9247("walkers")
                .requires(source -> source.method_9259(2)).build();

        /*
         * Used to remove the second shape of the specified Player.
         */
        LiteralCommandNode<class_2168> remove2ndShape = class_2170.method_9247("remove2ndShape")
                .then(class_2170.method_9244("players", class_2186.method_9308()).executes(context -> {
                    for (class_3222 player : class_2186.method_9312(context, "players")) {
                        remove2ndShape(context.getSource(), player);
                    }
                    return 1;
                })).build();

        /*
         * Used to give the specified shape to the specified Player.
         */
        LiteralCommandNode<class_2168> change2ndShape = class_2170.method_9247("change2ndShape")
                .then(class_2170.method_9244("players", class_2186.method_9308())
                        .then(class_2170.method_9244("entity", class_2186.method_9309())
                                .executes(context -> {
                                    class_1297 entity = class_2186.method_9313(context, "entity");
                                    class_2487 nbt = new class_2487();
                                    entity.method_5647(nbt);
                                    for (class_3222 player : class_2186.method_9312(context, "players")) {
                                        change2ndShape(context.getSource(),
                                                player,
                                                class_1299.method_5890(entity.method_5864()),
                                                nbt);
                                    }

                                    return 1;
                                }))
                        .then(class_2170.method_9244("shape", CEntitySummonArgument.id(ctx))
                                .suggests(class_2321.field_10935).executes(context -> {
                                    for (class_3222 player : class_2186.method_9312(context, "players")) {
                                        change2ndShape(context.getSource(),
                                                player,
                                                CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                                null);
                                    }
                                    return 1;
                                }).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                        .executes(context -> {
                                            class_2487 nbt = class_2179.method_9285(context, "nbt");
                                            for (class_3222 player : class_2186.method_9312(context, "players")) {
                                                change2ndShape(context.getSource(),
                                                        player,
                                                        CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                                        nbt);
                                            }
                                            return 1;
                                        }))))
                .build();

        LiteralCommandNode<class_2168> switchShape = class_2170.method_9247("switchShape").then(class_2170.method_9244("players", class_2186.method_9308())
                        .then(class_2170.method_9247("normal").executes(context -> {
                            for (class_3222 player : class_2186.method_9312(context, "players")) {
                                switchShapeToNormal(context.getSource(), player);
                            }
                    return 1;
                }))
                    .then(class_2170.method_9244("entity", class_2186.method_9309())
                                .executes(context -> {
                                    class_1297 entity = class_2186.method_9313(context, "entity");
                                    class_2487 nbt = new class_2487();
                                    entity.method_5647(nbt);
                                    for (class_3222 player : class_2186.method_9312(context, "players")) {
                                        switchShape(context.getSource(),
                                                player,
                                                class_1299.method_5890(entity.method_5864()),
                                                nbt);
                                    }
                                    return 1;
                                })).then(class_2170.method_9244("shape", CEntitySummonArgument.id(ctx))
                        .suggests(class_2321.field_10935).executes(context -> {
                                    for (class_3222 player : class_2186.method_9312(context, "players")) {
                                        switchShape(context.getSource(),
                                                player,
                                                CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                                null);
                                    }
                            return 1;
                        }).then(class_2170.method_9244("nbt", class_2179.method_9284()).executes(context -> {
                            class_2487 nbt = class_2179.method_9285(context, "nbt");
                            for (class_3222 player : class_2186.method_9312(context, "players")) {
                                switchShape(context.getSource(),
                                        player,
                                        CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                        nbt);
                            }
                            return 1;
                        }))))
                .build();

        LiteralCommandNode<class_2168> show2ndShape = class_2170.method_9247("show2ndShape")
                .then(class_2170.method_9244("players", class_2186.method_9308())
                        .executes(context -> {
                            for (class_3222 player : class_2186.method_9312(context, "players")) {
                                show2ndShape(context.getSource(), player);
                            }
                            return 1;
                        }))
                .build();

        rootNode.addChild(remove2ndShape);
        rootNode.addChild(change2ndShape);
        rootNode.addChild(switchShape);
        rootNode.addChild(show2ndShape);

        rootNode.addChild(PlayerBlacklistCommands.getRootNode());
        //#if MC>1182
        rootNode.addChild(EntityBlacklistCommands.getRootNode(ctx));
        //#else
        //$$ rootNode.addChild(EntityBlacklistCommands.getRootNode());
        //#endif

        dispatcher.getRoot().addChild(rootNode);
    }

    private static void show2ndShape(class_2168 source, class_3222 player) {
        if (((PlayerDataProvider) player).walkers$get2ndShape() != null) {
            ShapeType<?> type = ((PlayerDataProvider) player).walkers$get2ndShape();
            if (type != null) {
                sendSuccess(source, TComponent.translatable("walkers.show2ndShapeNot_positive",
                        player.method_5476(), ShapeType.createTooltipText(type.create(CEntity.level(player), player))), false);
            }
        } else {
            sendSuccess(source, TComponent.translatable("walkers.show2ndShapeNot_failed", player.method_5476()), false);
        }
    }

    private static void remove2ndShape(class_2168 source, class_3222 player) {

        change2ndShape(player, null);

        player.method_7353(TComponent.translatable("walkers.remove_entity"), true);
        sendSuccess(source, TComponent.translatable("walkers.deletion_success", player.method_5476()), false);
    }

    @SuppressWarnings("unchecked")
    private static void change2ndShape(class_2168 source, class_3222 player, class_2960 id,
                                       @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = ShapeType.from((class_1299<class_1309>) Walkers.getEntityTypeRegistry().method_10223(id));
        class_2561 name = TComponent.translatable(type.getEntityType().method_5882());

        // If the specified granting NBT is not null, change the ShapeType to reflect
        // potential variants.
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_9225();
            class_1297 loaded = class_1299.method_17842(copy, serverWorld, it -> it);
            if (loaded instanceof class_1309 living) {
                type = ShapeType.from(living);
                name = ShapeType.createTooltipText(living);
            }
        }

        if (((PlayerDataProvider) player).walkers$get2ndShape() != type) {
            change2ndShape(player, type);

            player.method_7353(TComponent.translatable("walkers.unlock_entity", name), false);
            sendSuccess(source, 
                    TComponent.translatable("walkers.grant_success", name, player.method_5476()), false);
        } else {
            sendSuccess(source, TComponent.translatable("walkers.already_has", player.method_5476(), name), false);
        }
    }

    private static void switchShape(class_2168 source, class_3222 player, class_2960 shape, @Nullable class_2487 nbt) {
        class_1297 created;

        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", shape.toString());
            class_3218 serverWorld = source.method_9225();
            created = class_1299.method_17842(copy, serverWorld, it -> it);
        } else {
            class_1299<?> entity = Walkers.getEntityTypeRegistry().method_10223(shape);
            created = entity.method_5883(CEntity.level(player));
        }

        if (created instanceof class_1309) {
            ((PlayerDataProvider) player).walkers$updateShapes((class_1309) created);
            sendSuccess(source, TComponent.translatable("walkers.switchShape_success",
                    player.method_5476(), TComponent.translatable(created.method_5864().method_5882())), false);
        }
    }

    private static void switchShapeToNormal(class_2168 source, class_3222 player) {
        boolean result = PlayerShape.updateShapes(player, null);

        if (result) {
            sendSuccess(source,
                    TComponent.translatable("walkers.switchShape_human_success", player.method_5476()), false);
        }
    }

    private static void change2ndShape(class_3222 player, ShapeType<?> newShape) {
        ((PlayerDataProvider) player).walkers$set2ndShape(newShape);
        PlayerShapeChanger.sync(player);
        PlayerAbilities.sync(player);
    }
}
