package tocraft.walkers.api;

//#if MC>1182
import tocraft.walkers.impl.tick.shapes.FrogTickHandler;
import tocraft.walkers.impl.tick.shapes.WardenTickHandler;
//#endif
import tocraft.walkers.impl.tick.shapes.JumpBoostTickHandler;
import tocraft.walkers.impl.tick.shapes.SnowGolemTickHandler;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;

public class WalkersTickHandlers {

    private static final Map<class_1299<?>, WalkersTickHandler<?>> HANDLERS = new LinkedHashMap<>();

    public static void initialize() {
        //#if MC>1182
        register(class_1299.field_38095, new WardenTickHandler());
        register(class_1299.field_37419, new FrogTickHandler());
        register(class_1299.field_40116, new JumpBoostTickHandler<>(0));
        //#endif
        register(class_1299.field_6047, new SnowGolemTickHandler());
        register(class_1299.field_6140, new JumpBoostTickHandler<>(1));
        register(class_1299.field_30052, new JumpBoostTickHandler<>(2));
        register(class_1299.field_6102, new JumpBoostTickHandler<>(2));
        register(class_1299.field_6069, new JumpBoostTickHandler<>(2));
    }

    public static <T extends class_1309> void register(class_1299<T> type, WalkersTickHandler<T> handler) {
        HANDLERS.put(type, handler);
    }

    public static Map<class_1299<?>, WalkersTickHandler<?>> getHandlers() {
        return HANDLERS;
    }
}
