package tocraft.walkers.ability.impl.generic;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1686;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.world.item.alchemy.PotionContents;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

import java.util.Arrays;
import java.util.List;

public class ThrowPotionsAbility<T extends class_1308> extends GenericShapeAbility<T> {
    //#if MC>=1205
    public static final List<class_6880<class_1842>> VALID_POTIONS = Arrays.asList(class_1847.field_9004, class_1847.field_8982, class_1847.field_8996, class_1847.field_8975);
    private final List<class_6880<class_1842>> validPotions;
    
    public ThrowPotionsAbility(List<class_6880<class_1842>> validPotions) {
       this.validPotions = validPotions;
    }
    //#else
    //$$ public static final List<Potion> VALID_POTIONS = Arrays.asList(Potions.HARMING, Potions.POISON, Potions.SLOWNESS, Potions.WEAKNESS);
    //$$ private final List<Potion> validPotions;
    //$$
    //$$ public ThrowPotionsAbility(List<Potion> validPotions) {
    //$$     this.validPotions = validPotions;
    //$$ }
    //#endif

    public static final class_2960 ID = Walkers.id("throw_potion");
    //#if MC>=1205
    public static final MapCodec<ThrowPotionsAbility<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            Codec.list(class_2960.field_25139).optionalFieldOf("potions", VALID_POTIONS.stream().map(potion -> class_7923.field_41179.method_10221(potion.comp_349())).toList()).forGetter(o -> o.validPotions.stream().map(potion -> class_7923.field_41179.method_10221(potion.comp_349())).toList())
    ).apply(instance, instance.stable(validPotions -> new ThrowPotionsAbility<>(validPotions.stream().map(potionId -> (class_6880<class_1842>) class_7923.field_41179.method_40265(potionId).orElseThrow()).toList()))));
    //#else
    //$$ @SuppressWarnings("unchecked")
    //$$ public static final MapCodec<ThrowPotionsAbility<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
    //$$         Codec.list(ResourceLocation.CODEC).optionalFieldOf("potions", VALID_POTIONS.stream().map(o -> ((Registry<Potion>) CRegistries.getRegistry(Identifier.parse("potion"))).getKey(o)).toList()).forGetter(o -> o.validPotions.stream().map(o1 -> ((Registry<Potion>) CRegistries.getRegistry(Identifier.parse("potion"))).getKey(o1)).toList())
    //$$ ).apply(instance, instance.stable(validPotions -> new ThrowPotionsAbility<>(validPotions.stream().map(o -> ((Registry<Potion>) CRegistries.getRegistry(Identifier.parse("potion"))).get(o)).toList()))));
    //#endif

    public ThrowPotionsAbility() {
        this(VALID_POTIONS);
    }

    @Override
    public void onUse(class_1657 player, T shape, class_1937 world) {
        class_1686 potionEntity = new class_1686(world, player);
        //#if MC>=1205
         potionEntity.method_16940(PotionContents.createItemStack(class_1802.field_8436, validPotions.get(world.field_9229.method_43048(validPotions.size()))));
        //#else
        //$$ potionEntity.setItem(PotionUtils.setPotion(new ItemStack(Items.SPLASH_POTION), validPotions.get(world.random.nextInt(validPotions.size()))));
        //#endif
        potionEntity.method_36457(-20.0F);
        class_243 rotation = player.method_5720();
        potionEntity.method_7485(rotation.method_10216(), rotation.method_10214(), rotation.method_10215(), 0.75F, 8.0F);

        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15067, player.method_5634(), 1.0F, 0.8F + world.field_9229.method_43057() * 0.4F);

        world.method_8649(potionEntity);
    }

    @Override
    public class_1792 getIcon() {
        return class_1802.field_8574;
    }

    @Override
    public int getDefaultCooldown() {
        return 200;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }
}
