package tocraft.walkers.registry;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1588;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2509;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.world.entity.monster.*;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.PlayerDataProvider;

public class WalkersEventHandlers {

    public static void initialize() {
        WalkersEventHandlers.registerHostilityUpdateHandler();
        WalkersEventHandlers.registerRavagerRidingHandler();
        WalkersEventHandlers.registerHostileHorseRidingHandler();
        WalkersEventHandlers.registerPlayerRidingHandler();
        WalkersEventHandlers.registerLivingDeathHandler();
    }

    public static void registerHostilityUpdateHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (!player.field_6002.field_9236 && entity instanceof class_1588) {
                PlayerHostility.set(player, Walkers.CONFIG.hostilityTime);
            }

            return EventResult.pass();
        });
    }

    // Players with an equipped Walkers inside the `ravager_riding` entity tag
    // should
    // be able to ride Ravagers.
    public static void registerRavagerRidingHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            // checks, if selected entity is a Ravager or a Player, shaped as a Ravager
            if (entity instanceof class_1584 || entity instanceof class_1657 targetedPlayer && ((PlayerDataProvider) targetedPlayer).walkers$getCurrentShape() instanceof class_1584) {
                class_1309 shape = PlayerShape.getCurrentShape(player);
                if (shape != null) {
                    if (shape.method_5864().method_20210(WalkersEntityTags.RAVAGER_RIDING)) {
                        player.method_5804(entity);
                    }
                }
            }

            return EventResult.pass();
        });
    }

    // hostile players should be able to ride hostile horses
    public static void registerHostileHorseRidingHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            // checks, if selected entity is a Ravager or a Player, shaped as a Ravager
            if (entity instanceof class_1506 || entity instanceof class_1507) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                if (shape instanceof class_1569) {
                    player.method_5804(entity);
                }
            }

            return EventResult.pass();
        });
    }

    // make this server-side
    public static void registerPlayerRidingHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (entity instanceof class_1657 playerToBeRidden) {
                if (PlayerShape.getCurrentShape(playerToBeRidden) instanceof class_1496) {
                    player.method_5873(playerToBeRidden, true);
                }
            }
            return EventResult.pass();
        });
    }

    public static void registerLivingDeathHandler() {
        EntityEvent.LIVING_DEATH.register((entity, damageSource) -> {
            if (!entity.field_6002.method_8608()) {
                if (entity instanceof class_1646 villager && damageSource.method_5529() instanceof class_1657 player && PlayerShape.getCurrentShape(player) instanceof class_1642) {
                    if (!(player.field_6002.method_8407() != class_1267.field_5807 && player.method_6051().method_43056())) {
                        class_1641 zombievillager = villager.method_29243(class_1299.field_6054, false);
                        if (zombievillager != null) {
                            zombievillager.method_5943((class_5425) player.field_6002, player.field_6002.method_8404(zombievillager.method_24515()), class_3730.field_16468, new class_1642.class_1644(false, true), null);
                            zombievillager.method_7195(villager.method_7231());
                            zombievillager.method_21649(villager.method_21651().method_19067(class_2509.field_11560));
                            zombievillager.method_16916(villager.method_8264().method_8268());
                            zombievillager.method_19622(villager.method_19269());
                        }
                    }
                }
            }
            return EventResult.pass();
        });
    }
}
