package tocraft.walkers.network.impl;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;
import tocraft.walkers.registry.WalkersEntityTags;

public class UnlockPackets {

    private static final String UNLOCK_KEY = "UnlockedShape";

    public static void handleUnlockSyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        class_2487 nbt = packet.method_10798();
        if (nbt != null) {
            class_2487 idTag = nbt.method_10562(UNLOCK_KEY);

            ClientNetworking.runOrQueue(context, player -> {
                if (!idTag.method_33133())
                    ((PlayerDataProvider) player).walkers$set2ndShape(ShapeType.from(idTag));
            });
        }
    }

    /**
     * Server handles request, that 2nd shape may be changed
     */
    @SuppressWarnings({"unchecked", "ConstantConditions"})
    public static void registerShapeUnlockRequestPacketHandler() {
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, NetworkHandler.UNLOCK_REQUEST, (buf, context) -> {
            // check if player is blacklisted
            if (Walkers.isPlayerBlacklisted(context.getPlayer().method_5667()))
                return;

            boolean validType = buf.readBoolean();
            if (validType) {
                class_2960 typeId = buf.method_10810();
                class_1299<? extends class_1309> entityType = (class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId);

                int variant = buf.readInt();

                context.getPlayer().method_5682().execute(() -> {
                    @Nullable
                    ShapeType<? extends class_1309> type = ShapeType.from(entityType, variant);
                    if (type != null && !type.getEntityType().method_20210(WalkersEntityTags.BLACKLISTED) && (Walkers.CONFIG.unlockOverridesCurrentShape || ((PlayerDataProvider) context.getPlayer()).walkers$get2ndShape() == null)) {
                        // set 2nd shape
                        boolean result = PlayerShapeChanger.change2ndShape((class_3222) context.getPlayer(), type);
                        // update Player
                        if (result)
                            PlayerShape.updateShapes((class_3222) context.getPlayer(),
                                    type.create(context.getPlayer().field_6002));
                    }
                });
            } else {
                // Swap back to player if server allows it
                context.getPlayer().method_5682().execute(() -> PlayerShape.updateShapes((class_3222) context.getPlayer(), null));
            }

            // Refresh player dimensions
            context.getPlayer().method_18382();
        });
    }

    /**
     * Server synchronizes unlocked shape with the client
     */
    public static void sendSyncPacket(class_3222 player) {
        class_2540 packet = new class_2540(Unpooled.buffer());

        // Serialize unlocked to tag
        class_2487 compound = new class_2487();
        class_2487 id = new class_2487();
        if (((PlayerDataProvider) player).walkers$get2ndShape() != null)
            id = ((PlayerDataProvider) player).walkers$get2ndShape().writeCompound();
        compound.method_10566(UNLOCK_KEY, id);
        packet.method_10794(compound);

        // Send to client
        NetworkManager.sendToPlayer(player, NetworkHandler.UNLOCK_SYNC, packet);
    }

    /**
     * Client requests, that server may unlock a shape
     */
    public static void sendUnlockRequest(@Nullable ShapeType<? extends class_1309> type) {
        class_2540 packet = new class_2540(Unpooled.buffer());

        packet.writeBoolean(type != null);
        if (type != null) {
            packet.method_10812(class_7923.field_41177.method_10221(type.getEntityType()));
            packet.writeInt(type.getVariantData());
        }

        NetworkManager.sendToServer(ClientNetworking.UNLOCK_REQUEST, packet);
    }
}
