package tocraft.walkers.network.impl;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class SpecialSwapPackets {

    @SuppressWarnings("ConstantConditions")
    public static void registerDevRequestPacketHandler() {
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, NetworkHandler.SPECIAL_SHAPE_REQUEST, (buf, context) -> context.getPlayer().method_5682().execute(() -> {
            class_3222 player = (class_3222) context.getPlayer();
            class_2960 shape = new class_2960("minecraft:wolf");

            // check if player has a special shape
            if (!Walkers.hasSpecialShape(player.method_5667()) || (!Walkers.CONFIG.specialShapeIsThirdShape && (((PlayerDataProvider) player).walkers$get2ndShape() == null || !((PlayerDataProvider) player).walkers$get2ndShape().getEntityType().equals(class_1299.field_6055))))
                return;

            class_1297 created;
            class_2487 nbt = new class_2487();

            nbt.method_10556("isSpecial", true);
            nbt.method_10582("id", shape.toString());
            class_3218 serverWorld = player.method_14220();
            created = class_1299.method_17842(nbt, serverWorld, it -> it);

            if (created instanceof class_1309 living) {
                PlayerShape.updateShapes(player, living);
            }

            // Refresh player dimensions
            player.method_18382();
        }));
    }

    public static void sendSpecialSwapRequest() {
        NetworkManager.sendToServer(ClientNetworking.SPECIAL_SHAPE_REQUEST, new class_2540(Unpooled.buffer()));
    }
}
