package tocraft.walkers.network;

import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.network.impl.SpecialSwapPackets;
import tocraft.walkers.network.impl.SwapPackets;
import tocraft.walkers.network.impl.UnlockPackets;

public class ServerNetworking implements NetworkHandler {

    public static void initialize() {
        SwapPackets.registerWalkersRequestPacketHandler();
        UnlockPackets.registerShapeUnlockRequestPacketHandler();
        SpecialSwapPackets.registerDevRequestPacketHandler();
        registerUseAbilityPacketHandler();
    }

    @SuppressWarnings("ConstantConditions")
    private static void registerUseAbilityPacketHandler() {
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, USE_ABILITY, (buf, context) -> {
            class_1657 player = context.getPlayer();

            context.getPlayer().method_5682().execute(() -> {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                // Verify we should use ability for the player's current shape
                if (shape != null) {
                    if (AbilityRegistry.has(shape)) {
                        // Check cooldown
                        if (PlayerAbilities.canUseAbility(player)) {
                            AbilityRegistry.get(shape).onUse(player, shape, context.getPlayer().field_6002);
                            PlayerAbilities.setCooldown(player, AbilityRegistry.get(shape).getCooldown(shape));
                            PlayerAbilities.sync((class_3222) player);
                        }
                    }
                }
            });
        });
    }
}
