package tocraft.walkers.mixin.player;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.impl.GrassEaterAbility;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandler;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.impl.VehiclePackets;

import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1433;
import net.minecraft.class_1454;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6088;
import net.minecraft.class_7924;

@SuppressWarnings("ConstantConditions")
@Mixin(class_1657.class)
public abstract class PlayerEntityTickMixin extends class_1309 {

    private PlayerEntityTickMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @SuppressWarnings({"unchecked", "rawtypes", "ConstantConditions"})
    @Inject(method = "tick", at = @At("HEAD"))
    private void serverTick(CallbackInfo info) {
        // Tick WalkersTickHandlers on the client & server.
        @Nullable class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
        if (shape != null) {
            @Nullable WalkersTickHandler handler = WalkersTickHandlers.getHandlers().get(shape.method_5864());
            if (handler != null) {
                handler.tick((class_1657) (Object) this, shape);
            }
        }

        // Update misc. server-side entity properties for the player.
        if (!field_6002.field_9236) {
            PlayerDataProvider data = (PlayerDataProvider) this;
            data.walkers$setRemainingHostilityTime(Math.max(0, data.walkers$getRemainingHostilityTime() - 1));

            // Update cooldown & Sync
            class_3222 player = (class_3222) (Object) this;
            PlayerAbilities.setCooldown(player, Math.max(0, data.walkers$getAbilityCooldown() - 1));
            PlayerAbilities.sync(player);

            VehiclePackets.sync((class_3222) (Object) this);
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void pufferfishServerTick(CallbackInfo info) {
        if (!field_6002.field_9236 && this.method_5805()) {
            class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
            if (shape instanceof class_1454 pufferfishShape) {
                if (pufferfishShape.field_6833 > 0) {
                    if (pufferfishShape.method_6594() == 0) {
                        this.method_5783(class_3417.field_15235, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(1);
                    } else if (pufferfishShape.field_6833 > 40 && pufferfishShape.method_6594() == 1) {
                        this.method_5783(class_3417.field_15235, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(2);
                    }

                    ++pufferfishShape.field_6833;
                } else if (pufferfishShape.method_6594() != 0) {
                    if (pufferfishShape.field_6832 > 60 && pufferfishShape.method_6594() == 2) {
                        this.method_5783(class_3417.field_15133, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(1);
                    } else if (pufferfishShape.field_6832 > 100 && pufferfishShape.method_6594() == 1) {
                        this.method_5783(class_3417.field_15133, this.method_6107(), this.method_6017());
                        pufferfishShape.method_6596(0);
                    }

                    ++pufferfishShape.field_6832;
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void dolphinServerTick(CallbackInfo info) {
        if (!field_6002.field_9236 && this.method_5805()) {
            class_1657 player = (class_1657) (Object) this;
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape instanceof class_1433) {
                class_1657 nearestPlayer = player.field_6002.method_18462(class_1433.field_18101, player);
                if (nearestPlayer != null && nearestPlayer.method_5681()) {
                    nearestPlayer.method_37222(new class_1293(class_1294.field_5900, 100), player);
                }
            }
        }
    }


    @Unique
    private static Predicate<class_2680> walkers$IS_TALL_GRASS = null;

    @Inject(method = "tick", at = @At("HEAD"))
    private void sheepServerTick(CallbackInfo info) {
        if (walkers$IS_TALL_GRASS == null) walkers$IS_TALL_GRASS = class_2715.method_11758(field_6002.method_30349().method_30530(class_7924.field_41254).method_10223(new class_2960("grass")));

        if (!field_6002.field_9236 && this.method_5805()) {
            class_3222 serverPlayer = (class_3222) (Object) this;
            class_1309 shape = PlayerShape.getCurrentShape(serverPlayer);
            if (shape != null && AbilityRegistry.get(shape) instanceof GrassEaterAbility<?> grassEaterAbility) {
                if (grassEaterAbility.eatTick.get(serverPlayer.method_5667()) != null && grassEaterAbility.eatTick.get(serverPlayer.method_5667()) != 0) {
                    grassEaterAbility.eatTick.put(serverPlayer.method_5667(), Math.max(0, grassEaterAbility.eatTick.get(serverPlayer.method_5667()) - 1));

                    if (shape instanceof class_1472 sheepShape)
                        sheepShape.field_6865 = grassEaterAbility.eatTick.get(serverPlayer.method_5667());

                    if (grassEaterAbility.eatTick.get(serverPlayer.method_5667()) == class_3532.method_38788(4, 2)) {
                        class_2338 blockPos = serverPlayer.method_24515();
                        if (walkers$IS_TALL_GRASS.test(field_6002.method_8320(blockPos)) && walkers$isLookingAtPos(blockPos)) {
                            field_6002.method_22352(blockPos, false);

                            method_32876(class_5712.field_28735);
                            serverPlayer.method_7344().method_7585(3, 0.2F);

                            if (shape instanceof class_1472 sheepShape) sheepShape.method_6635(false);
                        } else {
                            class_2338 blockPos2 = blockPos.method_10074();
                            if (field_6002.method_8320(blockPos2).method_27852(class_2246.field_10219) && walkers$isLookingAtPos(blockPos2)) {
                                field_6002.method_20290(class_6088.field_31144, blockPos2, class_2248.method_9507(class_2246.field_10219.method_9564()));
                                field_6002.method_8652(blockPos2, class_2246.field_10566.method_9564(), 2);

                                method_32876(class_5712.field_28735);
                                serverPlayer.method_7344().method_7585(3, 0.1F);

                                if (shape instanceof class_1472 sheepShape) sheepShape.method_6635(false);
                            }
                        }

                    }
                }
            }
        }
    }

    @Unique
    private boolean walkers$isLookingAtPos(class_2338 blockPos) {
        class_1657 player = (class_1657) (Object) this;
        return player.method_5745(2, 0, false) instanceof class_3965 blockHitResult && blockHitResult.method_17777().equals(blockPos);
    }
}
