package tocraft.walkers.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1493;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_969;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;

@Environment(EnvType.CLIENT)
@Mixin(class_969.class)
public class WolfRendererMixin {
    @Unique
    private static final class_2960 SPECIAL_WILD = Walkers.id("textures/entity/wolf/special_wild.png");
    @Unique
    private static final class_2960 SPECIAL_TAMED = Walkers.id("textures/entity/wolf/special_tame.png");
    @Unique
    private static final class_2960 SPECIAL_ANGRY = Walkers.id("textures/entity/wolf/special_angry.png");

    @Inject(method = "getTextureLocation(Lnet/minecraft/world/entity/animal/Wolf;)Lnet/minecraft/resources/ResourceLocation;", at = @At("HEAD"), cancellable = true)
    private void onGetTexture(class_1493 wolfEntity, CallbackInfoReturnable<class_2960> ci) {
        class_2487 nbt = new class_2487();
        wolfEntity.method_5647(nbt);

        if (nbt.method_10545("isSpecial")) {
            if (nbt.method_10577("isSpecial")) {
                if (wolfEntity.method_6181()) {
                    ci.setReturnValue(SPECIAL_TAMED);
                } else {
                    ci.setReturnValue(wolfEntity.method_29511() ? SPECIAL_ANGRY : SPECIAL_WILD);
                }
            }
        }
    }
}
